/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.pfs;

import com.djrapitops.pfs.Loader;
import com.djrapitops.pfs.VersionChecker;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class PFS
extends JavaPlugin {
    public void onEnable() {
        Logger logger = this.getLogger();
        this.loadDefaultConfig();
        if (this.getConfig().getBoolean("Check_for_updates")) {
            logger.info(VersionChecker.checkVersion());
        }
        logger.info("Plugin Folder Swapper enabled.");
        logger.info("-- Loading plugins.. --");
        List<String> loadedPlugins = this.loadPlugins();
        logger.info("-- Plugins loaded. --");
        this.logPluginInformation(loadedPlugins);
    }

    private void logPluginInformation(List<String> loadedPlugins) {
        StringBuilder loadedBuilder = new StringBuilder("Loaded " + loadedPlugins.size() + " plugins: ");
        PluginManager pluginManager = this.getServer().getPluginManager();
        for (String loadedPlugin : loadedPlugins) {
            Plugin plugin = pluginManager.getPlugin(loadedPlugin);
            if (plugin == null) {
                loadedBuilder.append(ChatColor.RED).append(loadedPlugin);
            } else if (!plugin.isEnabled()) {
                loadedBuilder.append(ChatColor.YELLOW).append(loadedPlugin);
            } else {
                loadedBuilder.append(ChatColor.GREEN).append(loadedPlugin);
            }
            loadedBuilder.append(ChatColor.RESET).append(", ");
        }
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        console.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cFailed to Load &eFailed to Enable &aEnabled"));
        console.sendMessage(loadedBuilder.toString());
    }

    private void loadDefaultConfig() {
        this.getDataFolder().mkdirs();
        this.getConfig().options().copyDefaults(true);
        this.getConfig().options().header("PFS | Plugin Folder Swapper - Config\nPluginPaths - Exact filepath to the plugins, can use %serverfolder%/blabla.. if can't see exact path.");
        this.saveConfig();
    }

    public void onDisable() {
    }

    public void log(String message) {
        Logger logger = this.getLogger();
        logger.info(message);
    }

    public void logError(String message) {
        this.getLogger().severe(message);
    }

    private List<String> loadPlugins() {
        return new Loader(this).loadPlugins();
    }
}

