/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.pfs;

import com.djrapitops.pfs.PFS;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.UnknownDependencyException;

public class Loader {
    private final PluginLoader pluginLoader;
    private final PluginManager pluginManager;
    private final Logger logger;
    private final FileConfiguration config;
    private final List<String> loadedPluginNames;
    private final List<String> pluginNamesLoadedByPfs;
    private final List<Plugin> loadedPlugins;
    private final String serverFolderPath;
    private Map<File, String> pluginNames;

    public Loader(PFS pfs) {
        this.logger = pfs.getLogger();
        this.config = pfs.getConfig();
        this.pluginLoader = pfs.getPluginLoader();
        this.pluginManager = pfs.getServer().getPluginManager();
        this.serverFolderPath = new File("").getAbsolutePath();
        this.logger.info("Server folder found at: " + this.serverFolderPath);
        this.loadedPlugins = new ArrayList<Plugin>();
        this.loadedPluginNames = Arrays.stream(this.pluginManager.getPlugins()).map(Plugin::getName).collect(Collectors.toList());
        this.pluginNamesLoadedByPfs = new ArrayList<String>();
    }

    public List<String> loadPlugins() {
        Set<File> files = this.findJarFiles(this.config.getStringList("PluginPaths"));
        if (files.isEmpty()) {
            this.logger.warning("No Plugins were found (is config set-up correctly?)");
            return new ArrayList<String>();
        }
        return this.loadPlugins(this.getInLoadOrder(files));
    }

    private List<String> loadPlugins(List<File> files) {
        for (File file : files) {
            String pluginName = this.pluginNames.get(file);
            if (this.loadedPluginNames.contains(pluginName)) continue;
            this.tryToLoadFromFile(file);
        }
        for (Plugin plugin : this.loadedPlugins) {
            if (plugin.isEnabled()) continue;
            this.pluginManager.enablePlugin(plugin);
        }
        return this.pluginNamesLoadedByPfs;
    }

    private void tryToLoadFromFile(File file) {
        try {
            this.loadPluginFromFile(file);
        }
        catch (InvalidDescriptionException | InvalidPluginException e) {
            this.logger.severe(e.toString());
        }
    }

    private void loadPluginFromFile(File pluginJar) throws InvalidDescriptionException, InvalidPluginException {
        try {
            Plugin plugin = this.pluginManager.loadPlugin(pluginJar);
            if (plugin != null) {
                this.loadedPlugins.add(plugin);
                String pluginName = plugin.getName();
                this.loadedPluginNames.add(pluginName);
                this.pluginNamesLoadedByPfs.add(pluginName);
                this.pluginNames.put(pluginJar, pluginName);
            }
        }
        catch (UnknownDependencyException e) {
            this.logger.severe(e.toString() + " while loading " + pluginJar.getName());
            e.printStackTrace();
        }
    }

    private List<File> getInLoadOrder(Set<File> files) {
        this.pluginNames = new HashMap<File, String>();
        return files.stream().sorted(this::loadOrderComparator).collect(Collectors.toList());
    }

    private int loadOrderComparator(File plugin1, File plugin2) {
        try {
            PluginDescriptionFile p1Desc = this.pluginLoader.getPluginDescription(plugin1);
            PluginDescriptionFile p2Desc = this.pluginLoader.getPluginDescription(plugin2);
            return p1Desc.getLoad().compareTo((Enum)p2Desc.getLoad());
        }
        catch (InvalidDescriptionException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private Set<File> findJarFiles(List<String> folderPaths) {
        HashSet<File> files = new HashSet<File>();
        for (String path : folderPaths) {
            if (path.endsWith("ExamplePlugin-1.0.jar")) continue;
            Path filePath = path.contains("%serverfolder%") ? Paths.get(this.serverFolderPath, new String[0]).resolve(path.replace("%serverfolder%/", "")) : Paths.get(path, new String[0]);
            if (this.isJar(filePath.toFile())) {
                files.add(filePath.toFile());
                continue;
            }
            this.findPluginsFromFolder(files, path, filePath);
        }
        return files;
    }

    private boolean isJar(File file) {
        return file.isFile() && file.getName().endsWith(".jar");
    }

    private void findPluginsFromFolder(Set<File> files, String path, Path filePath) {
        File folder = filePath.toFile();
        if (folder.isFile()) {
            return;
        }
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null || listOfFiles.length == 0) {
            this.logger.severe("Incorrect/Empty/Non-Existent folder in config: " + path);
            return;
        }
        for (File pluginFile : listOfFiles) {
            if (!this.isJar(pluginFile)) continue;
            files.add(pluginFile);
        }
    }
}

