/*
 * Decompiled with CFR 0.152.
 */
package gmail.Sobky.OneShot.Timers;

import gmail.Sobky.OneShot.Commands.CommandHandler;
import gmail.Sobky.OneShot.Controller.Controller;
import gmail.Sobky.OneShot.Listeners.GameListener;
import gmail.Sobky.OneShot.Messages.Messages;
import gmail.Sobky.OneShot.MultipleUses;
import gmail.Sobky.OneShot.OneShot;
import gmail.Sobky.OneShot.ScoreBoard.SB;
import gmail.Sobky.OneShot.Timers.LobbyTimer;
import gmail.Sobky.OneShot.WorkWithSign;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GameTimer {
    private OneShot plugin;
    public static HashMap<String, Integer> GAMECOUNTDOWN = new HashMap();

    public GameTimer(OneShot plugin, LobbyTimer lobbyTimer) {
        this.plugin = plugin;
    }

    public void startTimer(final String arena) {
        GAMECOUNTDOWN.put(arena, CommandHandler.ARENAS.get(arena).get(3));
        SB.createGameScoreBoard(arena);
        new BukkitRunnable(){

            public void run() {
                if (Controller.sumOfPlayersInArena(arena) >= CommandHandler.ARENAS.get(arena).get(0)) {
                    if (GAMECOUNTDOWN.get(arena) == CommandHandler.ARENAS.get(arena).get(3) / 2) {
                        for (Player player : CommandHandler.PLAYERSINGAME) {
                            if (!CommandHandler.PLAYERSANDTHEIRARENA.get(player).contains(arena)) continue;
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Messages.nameOfPlugin) + " " + Messages.gameEndsIn.replace("{time}", "" + GAMECOUNTDOWN.get(arena)))));
                        }
                    } else if (GAMECOUNTDOWN.get(arena) <= 5 && GAMECOUNTDOWN.get(arena) > 0) {
                        for (Player player : CommandHandler.PLAYERSINGAME) {
                            if (!CommandHandler.PLAYERSANDTHEIRARENA.get(player).contains(arena)) continue;
                            GameTimer.this.plugin.getActionbar().playSound(player);
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Messages.nameOfPlugin) + " " + Messages.gameEndsIn.replace("{time}", "" + GAMECOUNTDOWN.get(arena)))));
                        }
                    }
                    if (GAMECOUNTDOWN.get(arena) != null && GAMECOUNTDOWN.get(arena) > 0) {
                        SB.updateGameScoreBoardHead(arena);
                        GAMECOUNTDOWN.put(arena, GAMECOUNTDOWN.get(arena) - 1);
                    }
                    if (GAMECOUNTDOWN.get(arena) == 0 || GameTimer.this.hasPlayerEnoughKills(arena)) {
                        this.cancel();
                        GAMECOUNTDOWN.remove(arena);
                        for (Player player : CommandHandler.PLAYERSINGAME) {
                            if (!CommandHandler.PLAYERSANDTHEIRARENA.get(player).contains(arena)) continue;
                            GameTimer.this.plugin.getActionbar().sendTitlesWithouReplacing(player, Messages.endGameTitle, Messages.endGameSubTitle);
                            player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
                        }
                        GameTimer.this.leaveGameAfterEndGame(arena);
                        GameListener.ISSHOOTINGALLOWED.put(arena, false);
                        if (OneShot.isBungee) {
                            OneShot.CurrentlyMotd = Controller.getStatusOfGame("ENDING");
                        } else {
                            WorkWithSign.updateSignStatusOfGame(arena, "ENDING");
                        }
                    }
                } else {
                    this.cancel();
                    GAMECOUNTDOWN.remove(arena);
                    for (Player player : CommandHandler.PLAYERSINGAME) {
                        if (!CommandHandler.PLAYERSANDTHEIRARENA.get(player).contains(arena)) continue;
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Messages.nameOfPlugin) + " " + Messages.lackOfPlayersInGame)));
                        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
                    }
                    GameTimer.this.leaveGame(arena);
                    GameListener.ISSHOOTINGALLOWED.put(arena, false);
                    if (OneShot.isBungee) {
                        OneShot.CurrentlyMotd = Controller.getStatusOfGame("ENDING");
                    } else {
                        WorkWithSign.updateSignStatusOfGame(arena, "ENDING");
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    protected boolean hasPlayerEnoughKills(String arena) {
        int kills = 0;
        for (Player player : CommandHandler.PLAYERSINGAME) {
            if (!CommandHandler.PLAYERSANDTHEIRARENA.get(player).contains(arena) || !GameListener.KILLS.containsKey(player) || GameListener.KILLS.get(player) <= kills) continue;
            kills = GameListener.KILLS.get(player);
        }
        return kills == CommandHandler.ARENAS.get(arena).get(4);
    }

    protected void leaveGameAfterEndGame(final String arena) {
        new BukkitRunnable(){

            public void run() {
                String winner = GameTimer.this.findWinner(arena);
                if (winner != null) {
                    for (Player player : CommandHandler.PLAYERSINGAME) {
                        if (!CommandHandler.PLAYERSANDTHEIRARENA.get(player).contains(arena)) continue;
                        GameTimer.this.plugin.getActionbar().sendTitles(player, Messages.winnerTitle, Messages.winnerSubTitle, "{player}", winner);
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Messages.nameOfPlugin) + " " + Messages.whoWon.replace("{game}", CommandHandler.PLAYERSANDTHEIRARENA.get(Bukkit.getPlayer((String)winner))).replace("{player}", winner))));
                    }
                }
                Iterator<Player> iterator = CommandHandler.PLAYERSINGAME.iterator();
                while (iterator.hasNext()) {
                    Player player = iterator.next();
                    if (!CommandHandler.PLAYERSANDTHEIRARENA.get(player).contains(arena)) continue;
                    iterator.remove();
                    MultipleUses.leavePlayer(player, arena, false, GameTimer.this.plugin);
                }
                CommandHandler.ISARENASTARTED.put(arena, false);
                SB.ISSTATSINSB.remove(arena);
                if (OneShot.isBungee) {
                    OneShot.CurrentlyMotd = Controller.getStatusOfGame("WAITING");
                } else {
                    WorkWithSign.updateSignStatusOfGame(arena, "WAITING");
                    WorkWithSign.updateSignNumOfPlayersInGame(arena);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 100L);
    }

    protected String findWinner(String arena) {
        int kills = 0;
        Player winner = null;
        for (Player player : CommandHandler.PLAYERSINGAME) {
            if (!CommandHandler.PLAYERSANDTHEIRARENA.get(player).contains(arena)) continue;
            if (GameListener.KILLS.containsKey(player) && GameListener.KILLS.get(player) > kills) {
                kills = GameListener.KILLS.get(player);
                winner = player;
            }
            if (this.plugin.getType() == null) continue;
            this.plugin.getType().playerKill(player, GameListener.KILLS.get(player));
            this.plugin.getType().playerDeath(player, GameListener.DEATHS.get(player));
            this.plugin.getType().playerPlayed(player);
        }
        if (winner != null) {
            if (this.plugin.getType() != null) {
                this.plugin.getType().playerWin(winner);
            }
            if (this.plugin.getConfig().getBoolean("allowRewardCmds")) {
                for (String cmdWinner : this.plugin.getConfig().getStringList("cmdForWiner")) {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmdWinner.replace("{player}", winner.getName()));
                }
            }
            if (this.plugin.getConfig().getBoolean("enableVault")) {
                OneShot.economy.depositPlayer(winner, (double)CommandHandler.ARENAS.get(arena).get(7).intValue());
                winner.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Messages.nameOfPlugin) + " " + Messages.addedMoneyReward.replace("{currBalance}", this.plugin.getConfig().getString("currencyChar")).replace("{money}", "" + CommandHandler.ARENAS.get(arena).get(7)))));
            }
            return winner.getName();
        }
        return null;
    }

    protected void leaveGame(final String arena) {
        new BukkitRunnable(){

            public void run() {
                Iterator<Player> iterator = CommandHandler.PLAYERSINGAME.iterator();
                while (iterator.hasNext()) {
                    Player player = iterator.next();
                    if (!CommandHandler.PLAYERSANDTHEIRARENA.get(player).contains(arena)) continue;
                    iterator.remove();
                    MultipleUses.leavePlayer(player, arena, false, GameTimer.this.plugin);
                }
                CommandHandler.ISARENASTARTED.put(arena, false);
                SB.ISSTATSINSB.remove(arena);
                OneShot.nameOfCurrentlyGame = (String)CommandHandler.ARENAS.keySet().toArray()[new Random().nextInt(CommandHandler.ARENAS.size())];
                if (OneShot.isBungee) {
                    OneShot.CurrentlyMotd = Controller.getStatusOfGame("WAITING");
                } else {
                    WorkWithSign.updateSignStatusOfGame(arena, "WAITING");
                    WorkWithSign.updateSignNumOfPlayersInGame(arena);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 100L);
    }
}

