/*
 * Decompiled with CFR 0.152.
 */
package gmail.Sobky.OneShot.Listeners;

import gmail.Sobky.OneShot.Commands.CommandHandler;
import gmail.Sobky.OneShot.Controller.Controller;
import gmail.Sobky.OneShot.GUI;
import gmail.Sobky.OneShot.Messages.Messages;
import gmail.Sobky.OneShot.MultipleUses;
import gmail.Sobky.OneShot.OneShot;
import gmail.Sobky.OneShot.ScoreBoard.SB;
import gmail.Sobky.OneShot.StoragePlayer;
import gmail.Sobky.OneShot.Teleports.TeleportToGameSpawn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GameListener
implements Listener {
    OneShot plugin;
    public static List<String> ALLOWEDCOMMANDS = new ArrayList<String>();
    public static HashMap<Player, Integer> KILLS = new HashMap();
    public static HashMap<Player, Integer> DEATHS = new HashMap();
    public static HashMap<String, Boolean> ISSHOOTINGALLOWED = new HashMap();
    public static HashMap<String, String> ITEMSANDTHEIRACTION = new HashMap();

    public GameListener(OneShot plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onLogin(PlayerLoginEvent event) {
        if (OneShot.isBungee && OneShot.nameOfCurrentlyGame != null && CommandHandler.ARENAS.get(OneShot.nameOfCurrentlyGame).get(1) == Controller.sumOfPlayersInArena(OneShot.nameOfCurrentlyGame)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, Messages.arenaIsFull.replace("{arena}", OneShot.nameOfCurrentlyGame).replace("&", "\u00a7").replace("\u00c4", ""));
            return;
        }
        if (OneShot.isBungee && OneShot.nameOfCurrentlyGame != null && CommandHandler.ARENAS.get(OneShot.nameOfCurrentlyGame).get(5) == 0 && !event.getPlayer().hasPermission("oneshot.admin.bypass")) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, Messages.arenaIsNotAllowed.replace("{arena}", OneShot.nameOfCurrentlyGame).replace("&", "\u00a7").replace("\u00c4", ""));
            return;
        }
        if (OneShot.isBungee && OneShot.nameOfCurrentlyGame != null && CommandHandler.ISARENASTARTED.get(OneShot.nameOfCurrentlyGame).booleanValue()) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, Messages.arenaIsAlreadyStarted.replace("&", "\u00a7").replace("\u00c4", ""));
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void separateChat(AsyncPlayerChatEvent event) {
        if (!this.plugin.getConfig().getBoolean("separateChat")) {
            return;
        }
        Player player = event.getPlayer();
        if (CommandHandler.PLAYERSINGAME.contains(player)) {
            String nameOfArenaOfPlayer = MultipleUses.getNameOfArena(player);
            Boolean isArenaStartdPlayer = CommandHandler.ISARENASTARTED.get(nameOfArenaOfPlayer);
            if (!isArenaStartdPlayer.booleanValue()) {
                Iterator recipiens = event.getRecipients().iterator();
                while (recipiens.hasNext()) {
                    String nameOfArenaOfRecipient;
                    Player recipient = (Player)recipiens.next();
                    if (!CommandHandler.PLAYERSANDTHEIRARENA.containsKey(recipient) || !CommandHandler.ISARENASTARTED.get(nameOfArenaOfRecipient = MultipleUses.getNameOfArena(recipient)).booleanValue()) continue;
                    recipiens.remove();
                }
                return;
            }
            Iterator recipiens = event.getRecipients().iterator();
            while (recipiens.hasNext()) {
                Player recipient = (Player)recipiens.next();
                if (!CommandHandler.PLAYERSINGAME.contains(recipient)) {
                    recipiens.remove();
                    continue;
                }
                if (CommandHandler.PLAYERSANDTHEIRARENA.get(recipient).contains(CommandHandler.PLAYERSANDTHEIRARENA.get(player))) continue;
                recipiens.remove();
            }
        } else {
            Iterator recipiens = event.getRecipients().iterator();
            while (recipiens.hasNext()) {
                String nameOfArenaOfPlayer;
                Player recipient = (Player)recipiens.next();
                if (!CommandHandler.PLAYERSANDTHEIRARENA.containsKey(recipient) || !CommandHandler.ISARENASTARTED.get(nameOfArenaOfPlayer = MultipleUses.getNameOfArena(recipient)).booleanValue()) continue;
                recipiens.remove();
            }
        }
    }

    @EventHandler
    public void onJoinBungee(PlayerJoinEvent event) {
        if (OneShot.isBungee && OneShot.nameOfCurrentlyGame != null) {
            Player player = event.getPlayer();
            Bukkit.dispatchCommand((CommandSender)player, (String)("os join " + OneShot.nameOfCurrentlyGame));
            return;
        }
    }

    @EventHandler
    public void onServerListPing(ServerListPingEvent event) {
        if (OneShot.isBungee && OneShot.nameOfCurrentlyGame != null) {
            event.setMotd(OneShot.CurrentlyMotd.replace("&", "\u00a7"));
        }
    }

    @EventHandler
    public void onItemsMove(InventoryClickEvent event) {
        final Player player = (Player)event.getWhoClicked();
        if (CommandHandler.PLAYERSINGAME.contains(player)) {
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            final String stripName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
            if (ITEMSANDTHEIRACTION.containsKey(stripName) && (ITEMSANDTHEIRACTION.get(stripName).contains("SWORD") || ITEMSANDTHEIRACTION.get(stripName).contains("ARROW") || ITEMSANDTHEIRACTION.get(stripName).contains("SPEED") || ITEMSANDTHEIRACTION.get(stripName).contains("EXPLOSION") || ITEMSANDTHEIRACTION.get(stripName).contains("SHIELD"))) {
                new BukkitRunnable(){

                    public void run() {
                        Bukkit.dispatchCommand((CommandSender)player, (String)("os kit " + ITEMSANDTHEIRACTION.get(stripName)));
                        if (GameListener.this.plugin.getConfig().getBoolean("closeInventoryAfterSelectKit")) {
                            player.closeInventory();
                        }
                    }
                }.runTask((Plugin)this.plugin);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerClick(final PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (OneShot.version.equals("v1_8_R3") ? player.getInventory().getItemInHand() == null && player.getInventory().getItemInHand().getType() == Material.AIR : player.getInventory().getItemInMainHand() == null && player.getInventory().getItemInMainHand().getType() == Material.AIR) {
                return;
            }
            if (!CommandHandler.PLAYERSINGAME.contains(player)) {
                return;
            }
            ItemStack itemInHand = OneShot.version.equals("v1_8_R3") ? player.getInventory().getItemInHand() : player.getInventory().getItemInMainHand();
            if (itemInHand.hasItemMeta() && itemInHand.getItemMeta().hasDisplayName()) {
                String stripName = ChatColor.stripColor((String)itemInHand.getItemMeta().getDisplayName());
                if (ITEMSANDTHEIRACTION.get(stripName).contains("LEAVE")) {
                    new BukkitRunnable(){

                        public void run() {
                            Bukkit.dispatchCommand((CommandSender)player, (String)"os leave");
                            event.setCancelled(true);
                        }
                    }.runTask((Plugin)this.plugin);
                } else if (ITEMSANDTHEIRACTION.get(stripName).contains("SELECTKIT")) {
                    new BukkitRunnable(){

                        public void run() {
                            GUI.openGUI(player, OneShot.version);
                            event.setCancelled(true);
                        }
                    }.runTask((Plugin)this.plugin);
                }
            }
        }
    }

    @EventHandler
    public void onPLayerLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (CommandHandler.PLAYERSINGAME.contains(player)) {
            String nameOfGame = MultipleUses.getNameOfArena(player);
            MultipleUses.leavePlayer(player, nameOfGame, false, this.plugin);
            MultipleUses.sayAboutLeftPlayer(player, nameOfGame);
        }
    }

    @EventHandler
    public void disableCommandsInGame(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (CommandHandler.PLAYERSINGAME.contains(player)) {
            String cmd = event.getMessage().substring(1).toLowerCase();
            for (String allowedCmd : ALLOWEDCOMMANDS) {
                if (!cmd.startsWith(allowedCmd.toLowerCase())) continue;
                return;
            }
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Messages.nameOfPlugin) + " " + Messages.blockedCommands)));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHitEventWithBow(EntityDamageByEntityEvent event) {
        Arrow arrow;
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Arrow && (arrow = (Arrow)event.getDamager()).getShooter() instanceof Player) {
            Player attacker = (Player)arrow.getShooter();
            Player victim = (Player)event.getEntity();
            if (CommandHandler.PLAYERSINGAME.contains(attacker) && CommandHandler.PLAYERSINGAME.contains(victim)) {
                if (ISSHOOTINGALLOWED.get(MultipleUses.getNameOfArena(victim)).booleanValue()) {
                    if (!victim.getName().equalsIgnoreCase(attacker.getName())) {
                        event.setCancelled(true);
                        KILLS.put(attacker, KILLS.get(attacker) + 1);
                        DEATHS.put(victim, DEATHS.get(victim) + 1);
                        attacker.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Messages.nameOfPlugin) + " " + Messages.playerIsAttacker.replace("{victim}", victim.getName()).replace("{kills}", KILLS.get(attacker).toString()))));
                        victim.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Messages.nameOfPlugin) + " " + Messages.playerIsVictim.replace("{attacker}", attacker.getName()))));
                        if (SB.ISSTATSINSB.get(MultipleUses.getNameOfArena(victim)).booleanValue()) {
                            SB.createGameScoreBoard(MultipleUses.getNameOfArena(victim));
                            SB.ISSTATSINSB.put(MultipleUses.getNameOfArena(victim), false);
                        }
                        if (this.plugin.getConfig().getBoolean("allowRewardCmds") && KILLS.get(attacker) % CommandHandler.ARENAS.get(MultipleUses.getNameOfArena(attacker)).get(6) == 0) {
                            for (String cmdKill : this.plugin.getConfig().getStringList("cmdForKiller")) {
                                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmdKill.replace("{player}", attacker.getName()));
                            }
                        }
                        this.plugin.getActionbar().playSoundKill(attacker);
                        victim.setHealth(20.0);
                        SB.updateGameScoreBoardBody(attacker, MultipleUses.getNameOfArena(victim));
                        StoragePlayer.addArrowToPlayer(attacker);
                        TeleportToGameSpawn.teleportToGameSpawn(victim, MultipleUses.getNameOfArena(victim));
                        StoragePlayer.setGameItems(victim);
                    } else {
                        event.setCancelled(true);
                    }
                } else {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onHitEventWithSwordOrHand(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Player) {
            Player attacker = (Player)event.getDamager();
            Player victim = (Player)event.getEntity();
            if (CommandHandler.PLAYERSINGAME.contains(attacker) && CommandHandler.PLAYERSINGAME.contains(victim)) {
                if (ISSHOOTINGALLOWED.get(MultipleUses.getNameOfArena(victim)).booleanValue()) {
                    if (victim.getHealth() <= event.getDamage()) {
                        if (!victim.getName().equalsIgnoreCase(attacker.getName())) {
                            event.setCancelled(true);
                            KILLS.put(attacker, KILLS.get(attacker) + 1);
                            DEATHS.put(victim, DEATHS.get(victim) + 1);
                            attacker.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Messages.nameOfPlugin) + " " + Messages.playerIsAttackerKill.replace("{victim}", victim.getName()).replace("{kills}", KILLS.get(attacker).toString()))));
                            victim.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Messages.nameOfPlugin) + " " + Messages.playerIsVictimKill.replace("{attacker}", attacker.getName()))));
                            if (SB.ISSTATSINSB.get(MultipleUses.getNameOfArena(victim)).booleanValue()) {
                                SB.createGameScoreBoard(MultipleUses.getNameOfArena(victim));
                                SB.ISSTATSINSB.put(MultipleUses.getNameOfArena(victim), false);
                            }
                            if (this.plugin.getConfig().getBoolean("allowRewardCmds") && KILLS.get(attacker) % CommandHandler.ARENAS.get(MultipleUses.getNameOfArena(attacker)).get(6) == 0) {
                                for (String cmdKill : this.plugin.getConfig().getStringList("cmdForKiller")) {
                                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmdKill.replace("{player}", attacker.getName()));
                                }
                            }
                            this.plugin.getActionbar().playSoundKill(attacker);
                            SB.updateGameScoreBoardBody(attacker, MultipleUses.getNameOfArena(victim));
                            if (!attacker.getInventory().contains(Material.ARROW)) {
                                StoragePlayer.addArrowToPlayer(attacker);
                            }
                            victim.setHealth(20.0);
                            TeleportToGameSpawn.teleportToGameSpawn(victim, MultipleUses.getNameOfArena(victim));
                            StoragePlayer.setGameItems(victim);
                        } else {
                            event.setCancelled(true);
                        }
                    }
                } else {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onHitEventRemoveArrow(ProjectileHitEvent event) {
        Player shooter;
        Arrow arrow;
        if (event.getEntity() instanceof Arrow && (arrow = (Arrow)event.getEntity()).getShooter() instanceof Player && CommandHandler.PLAYERSINGAME.contains(shooter = (Player)arrow.getShooter())) {
            if (CommandHandler.SELECTEDKIT.containsKey(shooter) && CommandHandler.SELECTEDKIT.get(shooter).contains("EXPLOSION")) {
                arrow.getWorld().createExplosion(arrow.getLocation().getX(), arrow.getLocation().getY(), arrow.getLocation().getZ(), 1.5f, false, false);
                arrow.remove();
            }
            if (ISSHOOTINGALLOWED.get(MultipleUses.getNameOfArena(shooter)).booleanValue()) {
                arrow.remove();
            }
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (CommandHandler.PLAYERSINGAME.contains(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        if (CommandHandler.PLAYERSINGAME.contains(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        if (CommandHandler.PLAYERSINGAME.contains(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(FoodLevelChangeEvent event) {
        Player player = (Player)event.getEntity();
        if (CommandHandler.PLAYERSINGAME.contains(player)) {
            player.setFoodLevel(20);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCancelFallDamage(EntityDamageEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && CommandHandler.PLAYERSINGAME.contains(player = (Player)event.getEntity()) && (event.getCause() == EntityDamageEvent.DamageCause.FALL || event.getCause() == EntityDamageEvent.DamageCause.FIRE || event.getCause() == EntityDamageEvent.DamageCause.LAVA || event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK)) {
            event.setCancelled(true);
            player.setFireTicks(0);
        }
    }
}

