/*
 * Decompiled with CFR 0.152.
 */
package de.omel.api.skin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Skin {
    String uuid;
    String name;
    String value;
    String signatur;

    public Skin(String uuid) {
        this.uuid = uuid;
        this.load();
    }

    public void inject(Player p) {
        GameProfile gp = ((CraftPlayer)p).getProfile();
        gp.getProperties().clear();
        if (this.getSkinName() == null) {
            return;
        }
        gp.getProperties().put((Object)this.getSkinName(), (Object)new Property(this.getSkinName(), this.getSkinValue(), this.getSkinSignatur()));
    }

    private void load() {
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + this.uuid + "?unsigned=false");
            URLConnection uc = url.openConnection();
            uc.setUseCaches(false);
            uc.setDefaultUseCaches(false);
            uc.addRequestProperty("User-Agent", "Mozilla/5.0");
            uc.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
            uc.addRequestProperty("Pragma", "no-cache");
            String json = new Scanner(uc.getInputStream(), "UTF-8").useDelimiter("\\A").next();
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(json);
            JSONArray properties = (JSONArray)((JSONObject)obj).get((Object)"properties");
            int i = 0;
            while (i < properties.size()) {
                try {
                    JSONObject property = (JSONObject)properties.get(i);
                    String name = (String)property.get((Object)"name");
                    String value = (String)property.get((Object)"value");
                    String signature = property.containsKey((Object)"signature") ? (String)property.get((Object)"signature") : null;
                    this.name = name;
                    this.value = value;
                    this.signatur = signature;
                }
                catch (Exception e) {
                    Bukkit.getLogger().log(Level.WARNING, "Failed to apply auth property", e);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSkinValue() {
        return this.value;
    }

    public String getSkinName() {
        return this.name;
    }

    public String getSkinSignatur() {
        return this.signatur;
    }
}

