/*
 * Decompiled with CFR 0.152.
 */
package de.omel.api.scheduler;

import de.omel.api.main.Api;
import de.omel.api.scheduler.SchedulerHandler;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class Scheduler {
    private TimerTask task;
    private ScheduledExecutorService service;

    public Scheduler() {
        ++Api.schdeduler;
        this.task = new TimerTask(){

            @Override
            public void run() {
                Scheduler.this.runTask();
            }
        };
        this.service = Executors.newScheduledThreadPool(1);
        SchedulerHandler.tasks.add(this);
    }

    public abstract void runTask();

    public synchronized void start(int initialDelay, int period, TimeUnit unit) {
        this.service.scheduleAtFixedRate(this.task, initialDelay, period, unit);
    }

    public synchronized void runTaskLater(int delay, TimeUnit unit) {
        this.service.schedule(this.task, (long)delay, unit);
    }

    public synchronized void cancel() {
        this.service.shutdown();
        this.task.cancel();
    }

    public void remove() {
        SchedulerHandler.tasks.remove(this);
    }
}

