/*
 * Decompiled with CFR 0.152.
 */
package de.omel.api.particles;

import de.omel.api.main.Api;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public abstract class Effekt {
    private int ticks = 20;
    private int amount = 0;
    private int radius = 100;
    private int speed = 1;
    private int period = -1;
    private int delay = 0;
    private Plugin pl;
    private BukkitTask task;
    private Effect effect;
    private Location loc;
    private Entity ent = null;

    public Effekt(Plugin pl) {
        this.pl = pl;
        ++Api.effect;
    }

    public Effekt setLocation(Location loc) {
        this.loc = loc;
        return this;
    }

    public Effekt setPeriod(int period) {
        this.period = period;
        return this;
    }

    public Effekt setSpeed(int speed) {
        this.speed = speed;
        return this;
    }

    public Effekt setParticleAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public Effekt setDelay(int delay) {
        this.delay = delay;
        return this;
    }

    public Effekt setEffect(Effect effect) {
        this.effect = effect;
        return this;
    }

    public Effekt setTicks(int ticks) {
        this.ticks = ticks;
        return this;
    }

    public Effekt setDisplayRadius(int radius) {
        this.radius = radius;
        return this;
    }

    public Location getLocation() {
        return this.loc;
    }

    public int getSpeed() {
        return this.speed;
    }

    public Effect getEffect() {
        return this.effect;
    }

    public int getDisplayRadius() {
        return this.radius;
    }

    public int getParticleAmount() {
        return this.amount;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getPeriod() {
        return this.period;
    }

    public BukkitTask getTask() {
        return this.task;
    }

    public Effekt attachToEntity(Entity ent) {
        this.ent = ent;
        return this;
    }

    public Entity getAttachedEntity() {
        return this.ent;
    }

    protected abstract void display();

    public void start() {
        this.task = new BukkitRunnable(){

            public void run() {
                if (Effekt.this.getEffect() == null) {
                    throw new IllegalArgumentException("The Effect Type cannot be null!");
                }
                if (Effekt.this.period > 0) {
                    Effekt effekt = Effekt.this;
                    effekt.period = effekt.period - 1;
                    if (Effekt.this.period <= 0) {
                        this.cancel();
                    }
                }
                if (Effekt.this.getAttachedEntity() != null) {
                    if (!Effekt.this.getLocation().getWorld().getEntities().contains(Effekt.this.getAttachedEntity())) {
                        this.cancel();
                    }
                    Effekt.this.setLocation(Effekt.this.getAttachedEntity().getLocation());
                }
                Effekt.this.display();
            }
        }.runTaskTimerAsynchronously(this.pl, (long)this.delay, (long)this.ticks);
    }

    public void cancel() {
        this.getTask().cancel();
    }
}

