/*
 * Decompiled with CFR 0.152.
 */
package de.omel.api.mysql;

import de.omel.api.main.Api;
import de.omel.api.mysql.Database;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MySQL
extends Database {
    private final String user;
    private final String database;
    private final String password;
    private final String port;
    private final String hostname;
    private Connection connection;

    public MySQL(String hostname, String port, String database, String username, String password) {
        this.hostname = hostname;
        this.port = port;
        this.database = database;
        this.user = username;
        this.password = password;
        this.connection = null;
        ++Api.mysql;
    }

    @Override
    public Connection forceConnection() throws SQLException, ClassNotFoundException {
        Class.forName("com.mysql.jdbc.Driver");
        this.connection = DriverManager.getConnection("jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database, this.user, this.password);
        return this.connection;
    }

    @Override
    public Connection openConnection() throws SQLException, ClassNotFoundException {
        if (this.checkConnection()) {
            return this.connection;
        }
        Class.forName("com.mysql.jdbc.Driver");
        this.connection = DriverManager.getConnection("jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database, this.user, this.password);
        return this.connection;
    }

    @Override
    public boolean checkConnection() throws SQLException {
        return this.connection != null && !this.connection.isClosed();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean closeConnection() throws SQLException {
        if (this.connection == null) {
            return false;
        }
        this.connection.close();
        this.connection = null;
        return true;
    }

    @Override
    public ResultSet querySQL(String query) throws SQLException, ClassNotFoundException {
        if (this.checkConnection()) {
            this.openConnection();
        }
        Statement statement = this.connection.createStatement();
        return statement.executeQuery(query);
    }

    @Override
    public int updateSQL(String query) throws SQLException, ClassNotFoundException {
        if (this.checkConnection()) {
            this.openConnection();
        }
        Statement statement = this.connection.createStatement();
        int i = statement.executeUpdate(query);
        statement.close();
        return i;
    }
}

