/*
 * Decompiled with CFR 0.152.
 */
package de.omel.api.itemstack;

import de.omel.api.main.Api;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullBuilder {
    private ItemStack current = new ItemStack(Material.SKULL_ITEM, 1, 3);
    private SkullMeta meta = (SkullMeta)this.current.getItemMeta();

    public SkullBuilder() {
        ++Api.itemBuilder;
    }

    public SkullBuilder setDisplayname(String displayname) {
        this.meta.setDisplayName(displayname);
        return this;
    }

    public SkullBuilder setLore(List<String> lore) {
        this.meta.setLore(lore);
        return this;
    }

    public SkullBuilder clearLore() {
        this.meta.setLore(null);
        return this;
    }

    public SkullBuilder clearDisplayName() {
        this.meta.setDisplayName(null);
        return this;
    }

    public SkullBuilder clearEnchantments() {
        this.current.getEnchantments().keySet().stream().forEach(e -> this.current.removeEnchantment(e));
        return this;
    }

    public SkullBuilder addEnchantment(Enchantment ench, int level, boolean bool) {
        this.meta.addEnchant(ench, level, bool);
        return this;
    }

    public SkullBuilder addUnsafeEnchantment(Enchantment ench, int level) {
        this.current.addUnsafeEnchantment(ench, level);
        return this;
    }

    public SkullBuilder setAmount(int am) {
        this.current.setAmount(am);
        return this;
    }

    public SkullBuilder setType(Material m) {
        this.current.setType(m);
        return this;
    }

    public SkullBuilder setOwner(String name) {
        this.meta.setOwner(name);
        return this;
    }

    public ItemStack build() {
        this.current.setItemMeta((ItemMeta)this.meta);
        return this.current;
    }
}

