/*
 * Decompiled with CFR 0.152.
 */
package de.omel.api.itemstack;

import de.omel.api.main.Api;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private ItemStack current;
    private ItemMeta meta;

    public ItemBuilder(ItemStack i) {
        this.current = i;
        this.meta = this.current.getItemMeta();
        ++Api.itemBuilder;
    }

    public ItemBuilder(Material m, int amount, short data) {
        this(new ItemStack(m, amount, data));
    }

    public ItemBuilder(Material m, int amount) {
        this(new ItemStack(m, amount));
    }

    public ItemBuilder(Material m) {
        this(new ItemStack(m, 1));
    }

    @Deprecated
    public ItemBuilder(int id, int amount, short data) {
        this(new ItemStack(id, amount, data));
    }

    @Deprecated
    public ItemBuilder(int id, int amount) {
        this(new ItemStack(id, amount));
    }

    @Deprecated
    public ItemBuilder(int id) {
        this(new ItemStack(id));
    }

    public ItemBuilder setDisplayname(String displayname) {
        this.meta.setDisplayName(displayname);
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        this.meta.setLore(lore);
        return this;
    }

    public ItemBuilder clearLore() {
        this.meta.setLore(null);
        return this;
    }

    public ItemBuilder clearDisplayName() {
        this.meta.setDisplayName(null);
        return this;
    }

    public ItemBuilder clearEnchantments() {
        this.current.getEnchantments().keySet().stream().forEach(e -> this.current.removeEnchantment(e));
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment ench, int level, boolean bool) {
        this.meta.addEnchant(ench, level, bool);
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment ench, int level) {
        this.current.addUnsafeEnchantment(ench, level);
        return this;
    }

    public ItemBuilder setAmount(int am) {
        this.current.setAmount(am);
        return this;
    }

    public ItemBuilder setType(Material m) {
        this.current.setType(m);
        return this;
    }

    public ItemBuilder hideFlags() {
        this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_POTION_EFFECTS, ItemFlag.HIDE_UNBREAKABLE});
        return this;
    }

    public ItemBuilder showFlags() {
        this.meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_POTION_EFFECTS, ItemFlag.HIDE_UNBREAKABLE});
        return this;
    }

    public ItemBuilder setUnbreakable(boolean brakeable) {
        this.meta.spigot().setUnbreakable(brakeable);
        return this;
    }

    public ItemStack build() {
        this.current.setItemMeta(this.meta);
        return this.current;
    }
}

