/*
 * Decompiled with CFR 0.152.
 */
package de.omel.api.inventory;

import com.google.common.collect.Lists;
import de.omel.api.event.QuickEvent;
import de.omel.api.itemstack.ItemBuilder;
import de.omel.api.main.Api;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Inv {
    private Inventory inv;

    public Inv(String title, int rows) {
        this.inv = Bukkit.createInventory(null, (int)(9 * rows), (String)title);
        ++Api.inventory;
    }

    public Inv(String title) {
        this(title, 1);
    }

    public Inv() {
        this("Inventory", 1);
    }

    public Inv(String title, InventoryType type) {
        this.inv = Bukkit.createInventory(null, (InventoryType)type, (String)title);
        ++Api.inventory;
    }

    public Inv(InventoryType type) {
        this("Inventory", type);
    }

    public void setItem(int pos, ItemStack item) {
        this.inv.setItem(pos, item);
    }

    public void setItem(int pos, ItemBuilder item) {
        this.inv.setItem(pos, item.build());
    }

    public void addItem(ItemStack item) {
        this.inv.addItem(new ItemStack[]{item});
    }

    public void addItem(Material m) {
        this.addItem(new ItemStack(m, 1));
    }

    public void addItem(Material m, int amount) {
        this.addItem(new ItemStack(m, amount));
    }

    public void addItem(ItemBuilder item) {
        this.inv.addItem(new ItemStack[]{item.build()});
    }

    public ItemStack getItem(int pos) {
        return this.inv.getItem(pos);
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public List<Player> getWatchers() {
        ArrayList temp = Lists.newArrayList();
        this.inv.getViewers().forEach(e -> {
            if (e instanceof Player) {
                temp.add((Player)e);
            }
        });
        return temp;
    }

    public void setCancelOnClick(final boolean cancel) {
        new QuickEvent<InventoryClickEvent>((Plugin)Api.getInstance()){

            @Override
            @EventHandler
            public void callEvent(InventoryClickEvent e) {
                if (!e.getClickedInventory().equals(Inv.this.inv)) {
                    return;
                }
                e.setCancelled(cancel);
            }
        };
    }

    public void update() {
        this.getWatchers().forEach(e -> e.updateInventory());
    }
}

