/*
 * Decompiled with CFR 0.152.
 */
package de.omel.api.hologram;

import com.google.common.collect.Lists;
import de.omel.api.file.FileBuilder;
import de.omel.api.hologram.HologramHandler;
import de.omel.api.main.Api;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class Hologram {
    private List<String> lines = new ArrayList<String>();
    private List<Entity> stands = new ArrayList<Entity>();
    private String hologramName;
    private Location loc;

    public Hologram(String name, Location loc) {
        this.hologramName = name;
        this.loc = loc;
        HologramHandler.holograms.add(this);
        ++Api.hologram;
    }

    public Hologram(String name) {
        this(name, null);
    }

    public List<String> getLines() {
        return this.lines;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }

    public Location getLocation() {
        return this.loc;
    }

    public double getX() {
        return this.loc.getX();
    }

    public double getY() {
        return this.loc.getY();
    }

    public double getZ() {
        return this.loc.getZ();
    }

    public World getWorld() {
        return this.loc.getWorld();
    }

    public String getName() {
        return this.hologramName;
    }

    public List<Entity> getArmorStands() {
        return this.stands;
    }

    public void addLine(String text) {
        this.lines.add(text);
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public void removeLine(int line) {
        if (this.lines.size() == 0) {
            return;
        }
        if (line > this.lines.size()) {
            return;
        }
        if (line < 0) {
            return;
        }
        this.lines.remove(line);
    }

    public void printInfo(CommandSender s) {
        DecimalFormat format = new DecimalFormat("#.##");
        s.sendMessage("\u00a77> Name: \u00a7e" + this.getName());
        s.sendMessage("\u00a77> Loc: World: \u00a7e" + this.getWorld().getName() + " \u00a77X: \u00a7e" + format.format(this.getX()) + " \u00a77Y: \u00a7e" + format.format(this.getY()) + " \u00a77Z: \u00a7e" + format.format(this.getZ()));
        int i = 0;
        for (String line : this.lines) {
            s.sendMessage("\u00a77> #" + i + " \u00a7r" + line);
            ++i;
        }
    }

    public void setLine(int line, String text) {
        if (line < 0) {
            return;
        }
        if (line > this.lines.size()) {
            return;
        }
        this.lines.set(line, text);
    }

    public void remove() {
        for (Entity e : this.stands) {
            e.remove();
        }
        this.stands.clear();
    }

    public void update() {
        Location l = this.loc;
        this.remove();
        for (String line : Lists.reverse(this.lines)) {
            ArmorStand stand = (ArmorStand)this.loc.getWorld().spawnEntity(l, EntityType.ARMOR_STAND);
            stand.setCustomName(line);
            stand.setCustomNameVisible(true);
            stand.setVisible(false);
            stand.setGravity(false);
            stand.setBasePlate(false);
            this.stands.add((Entity)stand);
            l = l.add(0.0, 0.25, 0.0);
        }
    }

    public void save() {
        FileBuilder f = new FileBuilder("plugins//Hologram//", "holos.yml");
        f.setValue(String.valueOf(this.getName()) + ".location.world", this.getLocation().getWorld().getName());
        f.setValue(String.valueOf(this.getName()) + ".location.x", this.getLocation().getX());
        f.setValue(String.valueOf(this.getName()) + ".location.y", this.getLocation().getY());
        f.setValue(String.valueOf(this.getName()) + ".location.z", this.getLocation().getZ());
        f.setValue(String.valueOf(this.getName()) + ".lines", this.getLines());
        f.save();
    }
}

