/*
 * Decompiled with CFR 0.152.
 */
package de.omel.api.fun;

import com.google.common.collect.Maps;
import de.omel.api.event.PetSpawnEvent;
import de.omel.api.main.Api;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Pet {
    private static HashMap<UUID, Pet> pets = Maps.newHashMap();
    private Entity ent;
    private EntityType type;
    private UUID uuid;
    private Player owner;

    public static Pet getPet(Player p) {
        if (!pets.containsKey(p.getUniqueId())) {
            throw new IllegalArgumentException("Pet is not set!");
        }
        return pets.get(p.getUniqueId());
    }

    public Pet(EntityType type) {
        this.type = type;
        pets.put(this.uuid, this);
        ++Api.pet;
    }

    public EntityType getType() {
        return this.type;
    }

    public void setOwner(Player p) {
        this.owner = p;
        this.uuid = p.getUniqueId();
    }

    public void spawn() {
        PetSpawnEvent event = new PetSpawnEvent(this);
        if (event.isCancelled()) {
            return;
        }
        this.ent = this.owner.getWorld().spawnEntity(this.owner.getLocation(), this.type);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public Collection<Pet> getPets() {
        return pets.values();
    }

    public HashMap<UUID, Pet> getPetMap() {
        return pets;
    }

    public Entity getEntity() {
        return this.ent;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Player getOwner() {
        return this.owner;
    }

    public void setName(String name) {
        this.getEntity().setCustomName(name);
    }

    public String getName() {
        return this.getEntity().getCustomName();
    }

    public void setAgeLock(boolean lock) {
        if (this.getEntity() instanceof Ageable) {
            ((Ageable)this.getEntity()).setAgeLock(lock);
        }
    }

    public void setAdult() {
        if (this.getEntity() instanceof Ageable) {
            ((Ageable)this.getEntity()).setAdult();
        }
    }

    public void setBaby() {
        if (this.getEntity() instanceof Ageable) {
            ((Ageable)this.getEntity()).setBaby();
        }
    }

    public World getWorld() {
        return this.getEntity().getWorld();
    }

    public void setPassenger(Player p) {
        this.getEntity().setPassenger((Entity)p);
    }

    public void ejectPassenger() {
        this.getEntity().eject();
    }

    public void walkToLocation(Location location, float speed) {
    }
}

