/*
 * Decompiled with CFR 0.152.
 */
package de.omel.api.entity;

import com.google.common.collect.Lists;
import de.omel.api.NMS.NMSReflection;
import de.omel.api.main.Api;
import java.lang.reflect.Method;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftCreature;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class CustomEntity {
    private Entity ent;
    static List<CustomEntity> entitys = Lists.newArrayList();

    public CustomEntity(EntityType type, Location loc) {
        this.ent = loc.getWorld().spawnEntity(loc, type);
        entitys.add(this);
        ++Api.customEntity;
    }

    public Entity getEntity() {
        return this.ent;
    }

    public void setName(String name) {
        this.ent.setCustomName(name);
    }

    public void setNoAI(boolean noAI) {
        EntityFunctions.setNoAITag(this.ent, noAI);
    }

    @Deprecated
    public void walkToLocation(Location location, float speed) {
        ((CraftCreature)this.ent).getHandle().getNavigation().a(location.getX(), location.getY(), location.getZ(), (double)speed);
    }

    public void setCustomNameVisible(boolean visible) {
        this.ent.setCustomNameVisible(visible);
    }

    public void ejectPassenger() {
        this.ent.eject();
    }

    public void setPassenger(Entity ent) {
        ent.setPassenger(ent);
    }

    public Entity getPassenger() {
        return this.ent.getPassenger();
    }

    public Location getLocation() {
        return this.ent.getLocation();
    }

    public String getName() {
        return this.ent.getCustomName();
    }

    public void remove() {
        this.ent.remove();
    }

    public void setAge(EntityAge age) {
        if (this.ent instanceof Ageable) {
            switch (age) {
                case ADULT: {
                    ((Ageable)this.ent).setAdult();
                    break;
                }
                case BABY: {
                    ((Ageable)this.ent).setBaby();
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException("Entity's age cannot be modified!");
        }
    }

    public static enum EntityAge {
        BABY,
        ADULT;

    }

    protected static class EntityFunctions {
        private static String serverVersion;
        private static Method getHandle;
        private static Method getNBTTag;
        private static Class<?> nmsEntityClass;
        private static Class<?> nbtTagClass;
        private static Method c;
        private static Method setInt;
        private static Method f;

        protected EntityFunctions() {
        }

        private static void setNoAITag(Entity ent, boolean noAI) {
            try {
                String version = NMSReflection.getVersion();
                Method k = Class.forName("net.minecraft.server." + version + ".EntityInsentient").getMethod("k", Boolean.TYPE);
                Object entity = Class.forName("org.bukkit.craftbukkit." + version + ".entity.CraftEntity").getMethod("getHandle", new Class[0]).invoke((Object)ent, new Object[0]);
                k.invoke(entity, noAI);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private static void setTag(Entity entity, boolean enabled, String tagName) {
            try {
                if (serverVersion == null) {
                    serverVersion = NMSReflection.getVersion();
                }
                if (getHandle == null) {
                    Class<?> craftEntity = Class.forName("org.bukkit.craftbukkit." + serverVersion + ".entity.CraftEntity");
                    getHandle = craftEntity.getDeclaredMethod("getHandle", new Class[0]);
                    getHandle.setAccessible(true);
                }
                Object nmsEntity = getHandle.invoke((Object)entity, new Object[0]);
                if (nmsEntityClass == null) {
                    nmsEntityClass = Class.forName("net.minecraft.server." + serverVersion + ".Entity");
                }
                if (getNBTTag == null) {
                    getNBTTag = nmsEntityClass.getDeclaredMethod("getNBTTag", new Class[0]);
                    getNBTTag.setAccessible(true);
                }
                Object tag = getNBTTag.invoke(nmsEntity, new Object[0]);
                if (nbtTagClass == null) {
                    nbtTagClass = Class.forName("net.minecraft.server." + serverVersion + ".NBTTagCompound");
                }
                if (tag == null) {
                    tag = nbtTagClass.newInstance();
                }
                if (c == null) {
                    c = nmsEntityClass.getDeclaredMethod("c", nbtTagClass);
                    c.setAccessible(true);
                }
                c.invoke(nmsEntity, tag);
                if (setInt == null) {
                    setInt = nbtTagClass.getDeclaredMethod("setInt", String.class, Integer.TYPE);
                    setInt.setAccessible(true);
                }
                int value = enabled ? 0 : 1;
                setInt.invoke(tag, tagName, value);
                if (f == null) {
                    f = nmsEntityClass.getDeclaredMethod("f", nbtTagClass);
                    f.setAccessible(true);
                }
                f.invoke(nmsEntity, tag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

