/*
 * Decompiled with CFR 0.152.
 */
package me.kangarko.compatbridge.model;

import me.kangarko.compatbridge.utils.VersionResolver;
import org.bukkit.Sound;

public enum CompSound {
    BLOCK_NOTE_HAT("NOTE_BASS", "BLOCK_NOTE_BLOCK_HAT"),
    BLOCK_NOTE_HARP("NOTE_SNARE_DRUM", "BLOCK_ANVIL_BREAK"),
    BLOCK_NOTE_BASS("NOTE_BASS", "BLOCK_NOTE_BLOCK_BASS"),
    BLOCK_ANVIL_FALL("ANVIL_LAND", "BLOCK_ANVIL_FALL"),
    BLOCK_DISPENSER_LAUNCH("ITEM_PICKUP"),
    BLOCK_FIRE_EXTINGUISH("FIRE_IGNITE"),
    BLOCK_GLASS_BREAK("GLASS"),
    BLOCK_CHEST_CLOSE("CHEST_CLOSE"),
    BLOCK_ANVIL_HIT("ANVIL_LAND"),
    ENTITY_ARROW_HIT_PLAYER("SUCCESSFUL_HIT"),
    ENTITY_EXPERIENCE_ORB_PICKUP("ORB_PICKUP"),
    ENTITY_CHICKEN_EGG("CHICKEN_EGG_POP"),
    ENTITY_ENDERDRAGON_FLAP("ENDERDRAGON_WINGS", "ENTITY_ENDER_DRAGON_FLAP"),
    ENTITY_ENDERDRAGON_DEATH("ENDERDRAGON_DEATH", "ENTITY_ENDER_DRAGON_DEATH"),
    ENTITY_ITEMFRAME_BREAK("FIREWORK_BLAST", "ENTITY_ITEM_FRAME_BREAK"),
    ENTITY_ITEM_PICKUP("ITEM_PICKUP"),
    ENTITY_FIREWORK_BLAST("FIREWORK_BLAST", "ENTITY_FIREWORK_ROCKET_BLAST"),
    ENTITY_FIREWORK_LAUNCH("FIREWORK_LAUNCH", "ENTITY_FIREWORK_ROCKET_LAUNCH"),
    ENTITY_FIREWORK_TWINKLE_FAR("FIREWORK_LAUNCH", "ENTITY_FIREWORK_ROCKET_TWINKLE_FAR"),
    ENTITY_FIREWORK_LARGE_BLAST_FAR("FIREWORK_LARGE_BLAST", "ENTITY_FIREWORK_ROCKET_LARGE_BLAST_FAR"),
    ENTITY_PLAYER_HURT("HURT_FLESH"),
    ENTITY_PLAYER_LEVELUP("LEVEL_UP"),
    ENTITY_PLAYER_BURP("BURP");

    private final Sound sound;
    private final String legacyName;
    private final String modernName;

    public Sound getSound() {
        return this.sound;
    }

    private CompSound(String legacyName) {
        this(legacyName, null);
    }

    private CompSound(String legacyName, String modernName) {
        this.legacyName = legacyName;
        this.modernName = modernName;
        this.sound = CompSound.parseSound(modernName, this.name(), legacyName);
    }

    private static Sound parseSound(String v1_13, String v1_9, String legacy) {
        if (VersionResolver.isAtLeast1_13()) {
            return Sound.valueOf((String)(v1_13 != null ? v1_13 : v1_9));
        }
        if (VersionResolver.isAtLeast1_9()) {
            return Sound.valueOf((String)v1_9);
        }
        return Sound.valueOf((String)legacy);
    }

    public static final Sound convert(String original) {
        CompSound s;
        int n;
        int n2;
        CompSound[] compSoundArray;
        if (VersionResolver.MC_1_13) {
            compSoundArray = CompSound.values();
            n2 = compSoundArray.length;
            n = 0;
            while (n < n2) {
                CompSound compSound = compSoundArray[n];
                if (original.equalsIgnoreCase(compSound.name()) || original.equalsIgnoreCase(compSound.legacyName) || compSound.modernName != null && original.equalsIgnoreCase(compSound.modernName)) {
                    return Sound.valueOf((String)(compSound.modernName != null ? compSound.modernName : compSound.name()));
                }
                ++n;
            }
        }
        if (VersionResolver.MC_1_9) {
            compSoundArray = CompSound.values();
            n2 = compSoundArray.length;
            n = 0;
            while (n < n2) {
                s = compSoundArray[n];
                if (original.equalsIgnoreCase(s.legacyName)) {
                    return Sound.valueOf((String)s.toString());
                }
                ++n;
            }
        } else {
            compSoundArray = CompSound.values();
            n2 = compSoundArray.length;
            n = 0;
            while (n < n2) {
                s = compSoundArray[n];
                if (original.equalsIgnoreCase(s.toString())) {
                    try {
                        return Sound.valueOf((String)s.legacyName);
                    }
                    catch (IllegalArgumentException ex) {
                        if (!VersionResolver.isAtLeast1_8()) {
                            return Sound.valueOf((String)"LEVEL_UP");
                        }
                        throw new RuntimeException(ex);
                    }
                }
                ++n;
            }
        }
        try {
            return Sound.valueOf((String)original);
        }
        catch (IllegalArgumentException ex) {
            if (!VersionResolver.isAtLeast1_8()) {
                return Sound.valueOf((String)"LEVEL_UP");
            }
            throw new RuntimeException(ex);
        }
    }
}

