/*
 * Decompiled with CFR 0.152.
 */
package me.kangarko.compatbridge.model;

import org.bukkit.DyeColor;

public enum CompDye {
    WHITE,
    ORANGE,
    MAGENTA,
    LIGHT_BLUE,
    YELLOW,
    LIME,
    PINK,
    GRAY,
    LIGHT_GRAY("SILVER"),
    CYAN,
    PURPLE,
    BLUE,
    BROWN,
    GREEN,
    RED,
    BLACK;

    private final DyeColor dye;

    private CompDye() {
        this(null);
    }

    private CompDye(String name) {
        DyeColor color;
        try {
            color = DyeColor.valueOf((String)this.name());
        }
        catch (IllegalArgumentException ex) {
            if (name == null) {
                throw new RuntimeException("Missing legacy name for DyeColor." + this.name());
            }
            color = DyeColor.valueOf((String)name);
        }
        if (color == null) {
            throw new RuntimeException("Failed to resolve DyeColor." + this.name());
        }
        this.dye = color;
    }

    public DyeColor getDye() {
        return this.dye;
    }

    public static final CompDye fromWoolData(byte data) {
        return CompDye.fromDye(DyeColor.getByWoolData((byte)data));
    }

    public static final CompDye fromDye(DyeColor dye) {
        CompDye[] compDyeArray = CompDye.values();
        int n = compDyeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompDye comp = compDyeArray[n2];
            if (comp.getDye() == dye) {
                return comp;
            }
            ++n2;
        }
        throw new RuntimeException("Could not get CompDye from DyeColor." + dye.toString());
    }
}

