/*
 * Decompiled with CFR 0.152.
 */
package kangarko.olddays.util;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import kangarko.olddays.OldDays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class ConfigUpdater {
    private static Status status;
    private static String latestVersion;

    static {
        latestVersion = OldDays.plugin.getDescription().getVersion();
    }

    public static void configCheck() {
        block23: {
            String plVersion = OldDays.plugin.getConfig().getString("version");
            if (!OldDays.plugin.getConfig().getBoolean("advanced.update-config")) {
                status = Status.DISABLED;
                return;
            }
            if (latestVersion.contains("SNAPSHOT") || latestVersion.contains("DEV") || plVersion.contains("SNAPSHOT") || plVersion.contains("DEV")) {
                status = Status.DISABLED;
                System.out.println("No config update on snapshot, happy testing!");
                return;
            }
            if (!latestVersion.equals(plVersion)) {
                try {
                    try {
                        if (plVersion.equals("1.2.4")) {
                            ConfigUpdater.updateConfigTo125();
                        } else if (Integer.valueOf(plVersion.replace(".", "")) < 124) {
                            status = Status.TOO_OLD;
                        } else if (Integer.valueOf(plVersion.replace(".", "")) > Integer.valueOf(latestVersion.replace(".", ""))) {
                            status = Status.INVALID;
                        }
                    }
                    catch (Exception ex) {
                        status = Status.ERROR;
                        Logger.getLogger("Minecraft").log(Level.WARNING, "&cUnable to update OldDays configuration.", ex);
                        try {
                            OldDays.plugin.saveConfig();
                            status = Status.SUCCESS;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            status = Status.ERROR;
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        OldDays.plugin.saveConfig();
                        status = Status.SUCCESS;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        status = Status.ERROR;
                    }
                    throw throwable;
                }
                try {
                    OldDays.plugin.saveConfig();
                    status = Status.SUCCESS;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    status = Status.ERROR;
                }
            } else {
                status = Status.UPDATE_NOT_NECESSARY;
            }
        }
        if (status == null) {
            return;
        }
        if (!status.equals((Object)Status.DISABLED) && !status.equals((Object)Status.UPDATE_NOT_NECESSARY)) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)ConfigUpdater.status.msg));
            if (status.equals((Object)Status.SUCCESS)) {
                ConfigUpdater.updateVersionMark();
            }
        }
    }

    private static void updateConfigTo125() {
        ConfigUpdater.setBoolean("advanced.old-bonemeal-on-grass");
        ConfigUpdater.set("misc.drop-chances.crops.first-stage", 0.2);
        ConfigUpdater.set("misc.drop-chances.crops.second-stage", 0.3);
        ConfigUpdater.set("misc.drop-chances.crops.third-stage", 0.55);
        ConfigUpdater.set("misc.drop-chances.crops.fourth-stage", 0.75);
        ConfigUpdater.setBoolean("misc.packets.enabled");
        ConfigUpdater.setBoolean("misc.packets.disable-player-sample-in-motd");
        ConfigUpdater.setBoolean("misc.packets.disable-chest-sound-and-animation");
        ConfigUpdater.setBoolean("misc.packets.disable-fall-particles");
        ConfigUpdater.setBoolean("misc.packets.disable-bonemeal-particles");
    }

    private static void updateVersionMark() {
        try {
            OldDays.plugin.getConfig().set("version", (Object)latestVersion);
            OldDays.plugin.getConfig().save(new File(OldDays.plugin.getDataFolder(), "config.yml"));
        }
        catch (Exception ex) {
            Logger.getLogger("Minecraft").log(Level.WARNING, "&cUnable to update OldDays configuration version mark.", ex);
        }
    }

    private static void set(String path, Object value) {
        OldDays.plugin.getConfig().set(path, value);
    }

    private static void setBoolean(String path) {
        ConfigUpdater.set(path, true);
    }

    private static enum Status {
        SUCCESS("&aConfiguration was updated for version " + OldDays.plugin.getDescription().getVersion()),
        ERROR("&c Config was NOT updated! Please regenerate it."),
        TOO_OLD("&4Your OldDays version is too old. We cannot update your configuration. Consider regenerating your config.yml."),
        INVALID("&4!!Critical Warning!! &cYour configuration seems to be invalid! Consider regenerating it before any damage occur."),
        DISABLED,
        UPDATE_NOT_NECESSARY;

        String msg;

        private Status() {
        }

        private Status(String msg) {
            this.msg = msg;
        }
    }
}

