/*
 * Decompiled with CFR 0.152.
 */
package kangarko.olddays;

import java.util.Arrays;
import java.util.List;
import kangarko.olddays.OldDays;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.util.Vector;

public class AnimalSpawn
implements Listener {
    private final List<EntityType> despawnable = Arrays.asList(EntityType.CHICKEN, EntityType.COW, EntityType.PIG, EntityType.SHEEP, EntityType.WOLF);

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkUnload(ChunkUnloadEvent e) {
        Entity[] chunkEntities;
        if (OldDays.plugin.isWorldIgnored(e.getWorld())) {
            return;
        }
        Entity[] entityArray = chunkEntities = e.getChunk().getEntities();
        int n = chunkEntities.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (this.despawnable.contains(entity.getType())) {
                entity.remove();
            }
            ++n2;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkLoad(ChunkLoadEvent e) {
        if (OldDays.plugin.isWorldIgnored(e.getWorld())) {
            return;
        }
        if (Math.random() * 10.0 < 1.0) {
            double X = 16.0 * Math.random();
            double Z = 16.0 * Math.random();
            double chunkX = e.getChunk().getX() * 16;
            double chunkZ = e.getChunk().getZ() * 16;
            Location baseLoc = this.getRealHighestBlockAt(new Location(e.getChunk().getWorld(), chunkX + X, 5.0, chunkZ + Z)).getLocation();
            Block baseLocBlock = baseLoc.getBlock();
            Material baseType = baseLocBlock.getType();
            String baseName = baseType.toString();
            List<String> comp = Arrays.asList("LONG_GRASS", "TALL_GRASS", "MYCEL", "MYCELIUM");
            if (baseType != Material.GRASS && baseType != Material.SNOW && !comp.contains(baseName) && !baseName.contains("LEAVES")) {
                return;
            }
            if (baseName.contains("LEAVES")) {
                int s = 30;
                while (s > 0) {
                    Block lowerBlock = baseLocBlock.getRelative(0, s * -1, 0);
                    if (lowerBlock.getType() == Material.GRASS) {
                        baseLoc = lowerBlock.getLocation();
                        baseLocBlock = lowerBlock;
                        break;
                    }
                    s = (short)(s - 1);
                }
            }
            EntityType type = this.despawnable.get((int)(Math.random() * 5.0));
            if (Arrays.asList("MYCEL", "MYCELIUM").contains(baseType.toString())) {
                type = EntityType.MUSHROOM_COW;
            }
            if (baseLocBlock.getBiome() == Biome.JUNGLE || baseLocBlock.getBiome() == Biome.JUNGLE_HILLS) {
                if (baseLocBlock.getRelative(0, 1, 0).getType() == Material.AIR && Math.random() > 0.5) {
                    type = EntityType.OCELOT;
                }
                return;
            }
            int spawnCount = (int)(Math.random() * 4.0);
            Location spawnLoc = new Location(baseLoc.getWorld(), baseLoc.getX(), baseLoc.getY() + 1.0, baseLoc.getZ());
            int i = spawnCount;
            while (i > 0) {
                Vector vector = new Vector(Math.random() * 3.0, 0.0, Math.random());
                baseLoc.getWorld().spawnEntity(spawnLoc, type).setVelocity(vector);
                --i;
            }
        }
    }

    public Block getRealHighestBlockAt(Location loc) {
        Location highest = loc.getWorld().getHighestBlockAt(loc).getLocation().subtract(0.0, 1.0, 0.0);
        return highest.getBlock();
    }
}

