/*
 * Decompiled with CFR 0.152.
 */
package de.snap20lp.offlineplayers;

import de.snap20lp.offlineplayers.OfflinePlayer;
import de.snap20lp.offlineplayers.events.OfflinePlayerDeathEvent;
import de.snap20lp.offlineplayers.events.OfflinePlayerDespawnEvent;
import de.snap20lp.offlineplayers.events.OfflinePlayerHitEvent;
import de.snap20lp.offlineplayers.events.OfflinePlayerSpawnEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public class OfflinePlayers
extends JavaPlugin
implements Listener {
    private final double version = 2.5;
    private final HashMap<UUID, OfflinePlayer> offlinePlayerList = new HashMap();
    private final HashMap<Integer, OfflinePlayer> entityOfflinePlayerHashMap = new HashMap();

    public static OfflinePlayers getInstance() {
        return (OfflinePlayers)OfflinePlayers.getPlugin(OfflinePlayers.class);
    }

    public void onEnable() {
        Bukkit.getConsoleSender().sendMessage("\u00a7aOfflinePlayers starting in version " + this.getVersion());
        if (this.getServer().getPluginManager().getPlugin("LibsDisguises") == null || this.getServer().getPluginManager().getPlugin("ProtocolLib") == null) {
            Bukkit.getConsoleSender().sendMessage("\u00a74[OfflinePlayers] ERROR: LibsDisguises is not activated! Please install LibsDisguises and ProtocolLib to use this plugin!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveDefaultConfig();
        try {
            EntityType.valueOf((String)this.getConfig().getString("OfflinePlayer.cloneEntity"));
            EntityType.valueOf((String)this.getConfig().getString("OfflinePlayer.cloneRawEntity"));
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage("\u00a74[OfflinePlayers] ERROR: The cloneEntities in the config.yml are not a valid EntityType!");
            Bukkit.getConsoleSender().sendMessage("\u00a74[OfflinePlayers] Please change the cloneEntities in the config.yml to a valid EntityType!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
        if (this.getServer().getPluginManager().getPlugin("LibsDisguises") != null && this.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
            this.getOfflinePlayerList().values().forEach(OfflinePlayer::despawnClone);
        }
    }

    @EventHandler
    public void on(EntityResurrectEvent entityResurrectEvent) {
        if (this.getEntityOfflinePlayerHashMap().containsKey(entityResurrectEvent.getEntity().getEntityId())) {
            if (this.getEntityOfflinePlayerHashMap().get(entityResurrectEvent.getEntity().getEntityId()) == null) {
                return;
            }
            OfflinePlayer offlinePlayer = this.getEntityOfflinePlayerHashMap().get(entityResurrectEvent.getEntity().getEntityId());
            if (offlinePlayer.getMainHand().getType() != Material.TOTEM_OF_UNDYING && offlinePlayer.getOffHand().getType() != Material.TOTEM_OF_UNDYING) {
                entityResurrectEvent.setCancelled(true);
                return;
            }
            entityResurrectEvent.getEntity().getWorld().playSound(entityResurrectEvent.getEntity().getLocation(), Sound.ITEM_TOTEM_USE, 100.0f, 1.0f);
            if (offlinePlayer.getMainHand().getType() == Material.TOTEM_OF_UNDYING) {
                offlinePlayer.getMainHand().setType(Material.AIR);
            } else if (offlinePlayer.getOffHand().getType() == Material.TOTEM_OF_UNDYING) {
                offlinePlayer.getOffHand().setType(Material.AIR);
            }
            OfflinePlayer newOfflinePlayer = new OfflinePlayer(offlinePlayer.getOfflinePlayer(), offlinePlayer.getCurrentSeconds(), offlinePlayer.getCloneEntity().getLocation(), offlinePlayer.getPlayerExp(), offlinePlayer.getCurrentHP(), offlinePlayer.getSavedInventoryContents(), offlinePlayer.getSavedArmorContents(), offlinePlayer.getMainHand(), offlinePlayer.getOffHand());
            this.getOfflinePlayerList().remove(offlinePlayer.getOfflinePlayer().getUniqueId());
            this.getEntityOfflinePlayerHashMap().remove(entityResurrectEvent.getEntity().getEntityId());
            offlinePlayer.despawnClone();
            this.getOfflinePlayerList().put(newOfflinePlayer.getOfflinePlayer().getUniqueId(), newOfflinePlayer);
            this.getEntityOfflinePlayerHashMap().put(newOfflinePlayer.getCloneEntity().getEntityId(), newOfflinePlayer);
        }
    }

    @EventHandler
    public void on(PlayerJoinEvent playerJoinEvent) {
        if (this.getOfflinePlayerList().containsKey(playerJoinEvent.getPlayer().getUniqueId())) {
            if (this.getOfflinePlayerList().get(playerJoinEvent.getPlayer().getUniqueId()) == null) {
                return;
            }
            OfflinePlayer clone = this.getOfflinePlayerList().get(playerJoinEvent.getPlayer().getUniqueId());
            OfflinePlayerDespawnEvent offlinePlayerDespawnEvent = new OfflinePlayerDespawnEvent(clone);
            Bukkit.getPluginManager().callEvent((Event)offlinePlayerDespawnEvent);
            playerJoinEvent.getPlayer().teleport(clone.getCloneEntity().getLocation());
            playerJoinEvent.getPlayer().getActivePotionEffects().forEach(potionEffect -> playerJoinEvent.getPlayer().removePotionEffect(potionEffect.getType()));
            playerJoinEvent.getPlayer().addPotionEffects(clone.getCloneEntity().getActivePotionEffects());
            playerJoinEvent.getPlayer().getInventory().setItemInMainHand(clone.getCloneEntity().getEquipment().getItemInMainHand());
            playerJoinEvent.getPlayer().getInventory().setItemInOffHand(clone.getCloneEntity().getEquipment().getItemInOffHand());
            if (clone.getCloneEntity().hasPotionEffect(PotionEffectType.SLOW) && clone.isCloneHasAI()) {
                playerJoinEvent.getPlayer().removePotionEffect(PotionEffectType.SLOW);
            }
            if (clone.isDead()) {
                if (playerJoinEvent.getPlayer().getEquipment() != null) {
                    playerJoinEvent.getPlayer().getEquipment().clear();
                }
                playerJoinEvent.getPlayer().setLevel(0);
                playerJoinEvent.getPlayer().setExp(0.0f);
                playerJoinEvent.getPlayer().setHealth(0.0);
            } else {
                playerJoinEvent.getPlayer().setFireTicks(clone.getCloneEntity().getFireTicks());
                playerJoinEvent.getPlayer().setHealth(clone.getCloneEntity().getHealth());
                clone.getAddedItems().forEach(itemStack -> {
                    if (itemStack != null) {
                        playerJoinEvent.getPlayer().getInventory().addItem(new ItemStack[]{itemStack});
                    }
                });
            }
            clone.despawnClone();
            this.getOfflinePlayerList().remove(playerJoinEvent.getPlayer().getUniqueId());
        }
    }

    @EventHandler
    public void on(PlayerQuitEvent playerQuitEvent) {
        Player quitPlayer = playerQuitEvent.getPlayer();
        if (this.getConfig().getStringList("OfflinePlayer.worldBlacklist").contains(quitPlayer.getWorld().getName())) {
            return;
        }
        if (this.getConfig().getStringList("OfflinePlayer.game-modeBlacklist").contains(quitPlayer.getGameMode().name())) {
            return;
        }
        if (this.getConfig().getBoolean("OfflinePlayer.permissions.enabled") && this.getConfig().getString("OfflinePlayer.permissions.permission") != null && !quitPlayer.hasPermission(this.getConfig().getString("OfflinePlayer.permissions.permission"))) {
            return;
        }
        OfflinePlayer offlinePlayer = new OfflinePlayer(quitPlayer, new ArrayList<ItemStack>(Arrays.asList(quitPlayer.getInventory().getContents())), quitPlayer.getEquipment() == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(Arrays.asList(quitPlayer.getInventory().getArmorContents())), quitPlayer.getEquipment().getItemInMainHand(), quitPlayer.getEquipment().getItemInOffHand());
        OfflinePlayerSpawnEvent offlinePlayerSpawnEvent = new OfflinePlayerSpawnEvent(offlinePlayer);
        Bukkit.getPluginManager().callEvent((Event)offlinePlayerSpawnEvent);
        this.getOfflinePlayerList().put(quitPlayer.getUniqueId(), offlinePlayer);
        this.getEntityOfflinePlayerHashMap().put(offlinePlayer.getCloneEntity().getEntityId(), offlinePlayer);
    }

    @EventHandler
    public void on(UndisguiseEvent undisguiseEvent) {
        if (this.getEntityOfflinePlayerHashMap().containsKey(undisguiseEvent.getEntity().getEntityId())) {
            OfflinePlayer offlinePlayer = this.getEntityOfflinePlayerHashMap().get(undisguiseEvent.getEntity().getEntityId());
            offlinePlayer.replaceCloneStats((LivingEntity)undisguiseEvent.getEntity());
        }
    }

    @EventHandler
    public void on(PlayerDropItemEvent event) {
        if (this.getConfig().getBoolean("OfflinePlayer.cloneItemPickup")) {
            event.getItemDrop().getNearbyEntities(6.0, 6.0, 6.0).forEach(entity -> {
                if (this.getEntityOfflinePlayerHashMap().containsKey(entity.getEntityId())) {
                    OfflinePlayer offlinePlayer = this.getEntityOfflinePlayerHashMap().get(entity.getEntityId());
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
                        if (!event.getItemDrop().getNearbyEntities(1.0, 1.0, 1.0).contains(offlinePlayer.getCloneEntity())) {
                            return;
                        }
                        offlinePlayer.getAddedItems().add(event.getItemDrop().getItemStack());
                        offlinePlayer.getCloneEntity().getWorld().playSound(offlinePlayer.getCloneEntity().getLocation(), Sound.ENTITY_ITEM_PICKUP, 100.0f, 2.0f);
                        event.getItemDrop().remove();
                    }, 50L);
                }
            });
        }
    }

    @EventHandler
    public void on(EntityCombustEvent event) {
        OfflinePlayer offlinePlayer;
        if (this.getEntityOfflinePlayerHashMap().containsKey(event.getEntity().getEntityId()) && (offlinePlayer = this.getEntityOfflinePlayerHashMap().get(event.getEntity().getEntityId())).getCloneEntity().getLocation().getBlock().getType() != Material.LAVA && offlinePlayer.getCloneEntity().getLocation().getBlock().getType() != Material.FIRE) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void on(EntityTargetEvent entityTargetEvent) {
        if (entityTargetEvent.getTarget() == null) {
            return;
        }
        if (this.getEntityOfflinePlayerHashMap().containsKey(entityTargetEvent.getTarget().getEntityId())) {
            entityTargetEvent.setCancelled(true);
            entityTargetEvent.setTarget(null);
        }
    }

    @EventHandler
    public void on(EntityDeathEvent event) {
        OfflinePlayer offlinePlayer = null;
        for (OfflinePlayer value : this.getOfflinePlayerList().values()) {
            if (!value.getCloneEntity().getUniqueId().equals(event.getEntity().getUniqueId())) continue;
            offlinePlayer = value;
            break;
        }
        if (offlinePlayer != null) {
            OfflinePlayerDeathEvent offlinePlayerDeathEvent = new OfflinePlayerDeathEvent(offlinePlayer);
            Bukkit.getPluginManager().callEvent((Event)offlinePlayerDeathEvent);
            event.getDrops().clear();
            for (ItemStack inventoryContent : offlinePlayer.getSavedInventoryContents()) {
                if (inventoryContent == null) continue;
                event.getDrops().add(inventoryContent);
            }
            offlinePlayer.getAddedItems().forEach(itemStack -> {
                if (itemStack != null) {
                    event.getDrops().add(itemStack);
                }
            });
            event.setDroppedExp(offlinePlayer.getPlayerExp());
            offlinePlayer.setHidden(true);
            offlinePlayer.despawnClone();
            offlinePlayer.setDead(true);
        }
    }

    @EventHandler
    public void on(EntityDamageEvent event) {
        if (event.getEntity().getType() == EntityType.valueOf((String)OfflinePlayers.getInstance().getConfig().getString("OfflinePlayer.cloneRawEntity")) && this.getEntityOfflinePlayerHashMap().containsKey(event.getEntity().getEntityId())) {
            OfflinePlayer offlinePlayer = this.getEntityOfflinePlayerHashMap().get(event.getEntity().getEntityId());
            if (!offlinePlayer.isCloneIsHittable()) {
                event.setCancelled(true);
                return;
            }
            event.getEntity().getWorld().playSound(event.getEntity().getLocation(), Sound.ENTITY_PLAYER_HURT, 100.0f, 1.0f);
        }
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent event) {
        Entity entity;
        if (this.getEntityOfflinePlayerHashMap().containsKey(event.getEntity().getEntityId()) && (entity = event.getDamager()) instanceof Player) {
            Player damager = (Player)entity;
            OfflinePlayer offlinePlayer = this.getEntityOfflinePlayerHashMap().get(event.getEntity().getEntityId());
            if (!offlinePlayer.isCloneIsHittable()) {
                event.setCancelled(true);
            } else {
                OfflinePlayerHitEvent offlinePlayerHitEvent = new OfflinePlayerHitEvent(offlinePlayer, damager);
                Bukkit.getPluginManager().callEvent((Event)offlinePlayerHitEvent);
                damager.playSound(damager.getLocation(), Sound.ENTITY_PLAYER_HURT, 100.0f, 1.0f);
            }
        }
    }

    public double getVersion() {
        return this.version;
    }

    public HashMap<UUID, OfflinePlayer> getOfflinePlayerList() {
        return this.offlinePlayerList;
    }

    public HashMap<Integer, OfflinePlayer> getEntityOfflinePlayerHashMap() {
        return this.entityOfflinePlayerHashMap;
    }
}

