/*
 * Decompiled with CFR 0.152.
 */
package de.snap20lp.offlineplayers;

import de.snap20lp.offlineplayers.OfflinePlayers;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class OfflinePlayer
implements Listener {
    private final org.bukkit.OfflinePlayer offlinePlayer;
    private final double currentHP;
    private final ArrayList<ItemStack> savedInventoryContents;
    private final ArrayList<ItemStack> addedItems = new ArrayList();
    private final ArrayList<ItemStack> savedArmorContents;
    private final ItemStack mainHand;
    private final ItemStack offHand;
    private final int playerExp;
    private final String customName;
    private final int despawnTimerSeconds = OfflinePlayers.getInstance().getConfig().getInt("OfflinePlayer.cloneDe-spawnTimer.timer");
    private Location spawnLocation;
    private int despawnTask = 0;
    private int updateTask = 0;
    private int currentSeconds = 0;
    private boolean isHidden = false;
    private boolean cloneIsHittable = OfflinePlayers.getInstance().getConfig().getBoolean("OfflinePlayer.cloneIsHittable");
    private boolean cloneHasAI = OfflinePlayers.getInstance().getConfig().getBoolean("OfflinePlayer.cloneHasAI");
    private boolean isDead = false;
    private boolean despawnTimerEnabled = OfflinePlayers.getInstance().getConfig().getBoolean("OfflinePlayer.cloneDe-spawnTimer.enabled");
    private LivingEntity cloneEntity;
    private TargetedDisguise disguisedEntity;

    public OfflinePlayer(Player player, ArrayList<ItemStack> savedInventoryContents, ArrayList<ItemStack> savedArmorContents, ItemStack mainHand, ItemStack offHand) {
        this.offlinePlayer = player;
        this.spawnLocation = player.getLocation();
        this.mainHand = mainHand;
        this.offHand = offHand;
        this.savedInventoryContents = savedInventoryContents;
        this.savedArmorContents = savedArmorContents;
        this.playerExp = player.getTotalExperience();
        this.currentHP = player.getHealth();
        String customName = OfflinePlayers.getInstance().getConfig().getString("OfflinePlayer.cloneName");
        customName = customName.replaceAll("%PLAYER_NAME", player.getName());
        this.customName = customName = customName.replaceAll("%DESPAWN_TIMER%", String.valueOf(this.despawnTimerSeconds - this.currentSeconds));
        this.spawnClone();
        this.despawnClone();
        this.setHidden(true);
        this.startTimers();
    }

    public OfflinePlayer(org.bukkit.OfflinePlayer player, int currentSeconds, Location spawnLocation, int playerExp, double currentHP, ArrayList<ItemStack> savedInventoryContents, ArrayList<ItemStack> savedArmorContents, ItemStack mainHand, ItemStack offHand) {
        this.offlinePlayer = player;
        this.mainHand = mainHand;
        this.spawnLocation = spawnLocation;
        this.offHand = offHand;
        this.savedInventoryContents = savedInventoryContents;
        this.savedArmorContents = savedArmorContents;
        this.playerExp = playerExp;
        this.currentHP = currentHP;
        this.currentSeconds = currentSeconds;
        String customName = OfflinePlayers.getInstance().getConfig().getString("OfflinePlayer.cloneName");
        customName = customName.replaceAll("%PLAYER_NAME", player.getName());
        this.customName = customName = customName.replaceAll("%DESPAWN_TIMER%", String.valueOf(this.despawnTimerSeconds - currentSeconds));
        this.spawnClone();
        this.despawnClone();
        this.setHidden(true);
        this.startTimers();
    }

    private void startTimers() {
        this.updateTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)OfflinePlayers.getInstance(), () -> {
            if (this.isDead()) {
                return;
            }
            int distance = OfflinePlayers.getInstance().getConfig().getInt("OfflinePlayer.cloneSpawnDistance");
            AtomicBoolean isNearby = new AtomicBoolean(false);
            this.cloneEntity.getNearbyEntities((double)distance, (double)distance, (double)distance).forEach(entity -> {
                if (entity.getEntityId() != this.cloneEntity.getEntityId() && entity.getEntityId() != this.disguisedEntity.getEntity().getEntityId()) {
                    if (entity.getType() == EntityType.PLAYER && !entity.getUniqueId().equals(this.offlinePlayer.getUniqueId())) {
                        isNearby.set(true);
                    } else if (entity instanceof Mob && OfflinePlayers.getInstance().getConfig().getBoolean("OfflinePlayer.cloneCanProvoke") && ((Mob)entity).getTarget() == null && ((Mob)entity).hasLineOfSight((Entity)this.cloneEntity)) {
                        ((Mob)entity).setTarget(this.cloneEntity);
                    }
                }
            });
            if (!isNearby.get() && !this.isHidden) {
                OfflinePlayer offlinePlayerClone = new OfflinePlayer(this.offlinePlayer, this.currentSeconds, this.cloneEntity.getLocation(), this.playerExp, this.cloneEntity.getHealth(), this.savedInventoryContents, this.savedArmorContents, this.cloneEntity.getEquipment().getItemInMainHand(), this.cloneEntity.getEquipment().getItemInOffHand());
                offlinePlayerClone.replaceCloneStats(this.cloneEntity);
                DisguiseAPI.undisguiseToAll((Entity)this.cloneEntity);
                this.cloneEntity.remove();
                this.despawnClone();
                OfflinePlayers.getInstance().getOfflinePlayerList().remove(this.offlinePlayer.getUniqueId());
                OfflinePlayers.getInstance().getEntityOfflinePlayerHashMap().remove(this.cloneEntity.getEntityId());
                this.cancelUpdateTask();
                this.cancelDespawnTask();
                OfflinePlayers.getInstance().getOfflinePlayerList().put(this.offlinePlayer.getUniqueId(), offlinePlayerClone);
                OfflinePlayers.getInstance().getEntityOfflinePlayerHashMap().put(offlinePlayerClone.getDisguisedEntity().getEntity().getEntityId(), offlinePlayerClone);
            }
            if (isNearby.get() && this.isHidden) {
                this.spawnClone();
                this.setHidden(false);
            }
        }, 10L, (long)OfflinePlayers.getInstance().getConfig().getInt("OfflinePlayer.cloneUpdateTimer"));
        if (this.despawnTimerEnabled) {
            this.despawnTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)OfflinePlayers.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (OfflinePlayer.this.currentSeconds >= OfflinePlayer.this.despawnTimerSeconds - 1) {
                        OfflinePlayer.this.despawnClone();
                        OfflinePlayer.this.cancelDespawnTask();
                        return;
                    }
                    ++OfflinePlayer.this.currentSeconds;
                    if (OfflinePlayer.this.cloneEntity.isValid()) {
                        String customName = OfflinePlayers.getInstance().getConfig().getString("OfflinePlayer.cloneName");
                        customName = customName.replaceAll("%PLAYER_NAME", OfflinePlayer.this.offlinePlayer.getName());
                        customName = customName.replaceAll("%DESPAWN_TIMER%", String.valueOf(OfflinePlayer.this.despawnTimerSeconds - OfflinePlayer.this.currentSeconds));
                        OfflinePlayer.this.cloneEntity.setCustomName(customName);
                        OfflinePlayer.this.disguisedEntity.getWatcher().setCustomName(customName);
                    }
                }
            }, 20L, 20L);
        }
    }

    private void cancelDespawnTask() {
        Bukkit.getScheduler().cancelTask(this.despawnTask);
    }

    private void cancelUpdateTask() {
        Bukkit.getScheduler().cancelTask(this.updateTask);
    }

    public void replaceCloneStats(LivingEntity entity) {
        this.cloneEntity.teleport(entity.getLocation());
        this.cloneEntity.setHealth(entity.getHealth());
        this.cloneEntity.setFireTicks(entity.getFireTicks());
        this.cloneEntity.setFallDistance(entity.getFallDistance());
        this.cloneEntity.setVelocity(entity.getVelocity());
        this.cloneEntity.setArrowsInBody(entity.getArrowsInBody());
        this.cloneEntity.setFreezeTicks(entity.getFreezeTicks());
        this.cloneEntity.setVisualFire(entity.isVisualFire());
    }

    public void spawnClone() {
        Entity clone;
        EntityType entityType = EntityType.valueOf((String)OfflinePlayers.getInstance().getConfig().getString("OfflinePlayer.cloneEntity"));
        try {
            clone = this.offlinePlayer.getPlayer().getWorld().spawnEntity(this.cloneEntity != null ? this.cloneEntity.getLocation() : this.spawnLocation, EntityType.valueOf((String)OfflinePlayers.getInstance().getConfig().getString("OfflinePlayer.cloneRawEntity")));
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage("\u00a74[OfflinePlayers] Could not spawn clone entity! Please check your config.yml! | Exception: " + e.getMessage());
            return;
        }
        if (clone instanceof LivingEntity) {
            ((LivingEntity)clone).setCanPickupItems(false);
            if (clone instanceof Ageable) {
                ((Ageable)clone).setAdult();
            }
            clone.setSilent(true);
            if (this.cloneHasAI) {
                ((LivingEntity)clone).setAI(true);
                ((LivingEntity)clone).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, Integer.MAX_VALUE, 255, false, false, false));
            }
            clone.setGravity(true);
            ((LivingEntity)clone).getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.cloneEntity == null ? this.currentHP : this.cloneEntity.getHealth());
            ((LivingEntity)clone).setHealth(this.cloneEntity == null ? this.currentHP : this.cloneEntity.getHealth());
            ((LivingEntity)clone).getEquipment().setArmorContents(this.cloneEntity == null ? this.savedArmorContents.toArray(new ItemStack[0]) : this.cloneEntity.getEquipment().getArmorContents());
            ((LivingEntity)clone).getEquipment().setItemInMainHand(this.cloneEntity == null ? this.mainHand : this.cloneEntity.getEquipment().getItemInMainHand());
            ((LivingEntity)clone).getEquipment().setItemInOffHand(this.cloneEntity == null ? this.offHand : this.cloneEntity.getEquipment().getItemInOffHand());
            this.offlinePlayer.getPlayer().getActivePotionEffects().forEach(potionEffect -> ((LivingEntity)clone).addPotionEffect(potionEffect));
            clone.setInvulnerable(!this.cloneIsHittable);
            clone.setCustomName(this.customName);
            this.cloneEntity = (LivingEntity)clone;
            Object targetedDisguise = entityType == EntityType.PLAYER ? new PlayerDisguise(this.offlinePlayer.getPlayer().getName()) : new MobDisguise(DisguiseType.getType((EntityType)entityType));
            targetedDisguise.setCustomDisguiseName(true);
            targetedDisguise.setExpires(Long.MAX_VALUE);
            targetedDisguise.getWatcher().setCustomName(this.customName);
            targetedDisguise.getWatcher().setYawLocked(true);
            targetedDisguise.getWatcher().setPitchLocked(true);
            targetedDisguise.getWatcher().setYawLock(Float.valueOf(this.offlinePlayer.getPlayer().getLocation().getYaw()));
            targetedDisguise.getWatcher().setPitchLock(Float.valueOf(this.offlinePlayer.getPlayer().getLocation().getPitch()));
            DisguiseAPI.disguiseToAll((Entity)clone, (Disguise)targetedDisguise);
            this.disguisedEntity = targetedDisguise;
        }
    }

    public void despawnClone() {
        if (this.cloneEntity != null) {
            this.cancelUpdateTask();
            this.cloneEntity.remove();
        }
    }

    public org.bukkit.OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public double getCurrentHP() {
        return this.currentHP;
    }

    public ArrayList<ItemStack> getSavedInventoryContents() {
        return this.savedInventoryContents;
    }

    public ArrayList<ItemStack> getAddedItems() {
        return this.addedItems;
    }

    public ArrayList<ItemStack> getSavedArmorContents() {
        return this.savedArmorContents;
    }

    public ItemStack getMainHand() {
        return this.mainHand;
    }

    public ItemStack getOffHand() {
        return this.offHand;
    }

    public int getPlayerExp() {
        return this.playerExp;
    }

    public String getCustomName() {
        return this.customName;
    }

    public int getDespawnTimerSeconds() {
        return this.despawnTimerSeconds;
    }

    public Location getSpawnLocation() {
        return this.spawnLocation;
    }

    public int getDespawnTask() {
        return this.despawnTask;
    }

    public int getUpdateTask() {
        return this.updateTask;
    }

    public int getCurrentSeconds() {
        return this.currentSeconds;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isCloneIsHittable() {
        return this.cloneIsHittable;
    }

    public boolean isCloneHasAI() {
        return this.cloneHasAI;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public boolean isDespawnTimerEnabled() {
        return this.despawnTimerEnabled;
    }

    public LivingEntity getCloneEntity() {
        return this.cloneEntity;
    }

    public TargetedDisguise getDisguisedEntity() {
        return this.disguisedEntity;
    }

    public void setSpawnLocation(Location spawnLocation) {
        this.spawnLocation = spawnLocation;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setCloneIsHittable(boolean cloneIsHittable) {
        this.cloneIsHittable = cloneIsHittable;
    }

    public void setCloneHasAI(boolean cloneHasAI) {
        this.cloneHasAI = cloneHasAI;
    }

    public void setDead(boolean isDead) {
        this.isDead = isDead;
    }

    public void setDespawnTimerEnabled(boolean despawnTimerEnabled) {
        this.despawnTimerEnabled = despawnTimerEnabled;
    }
}

