/*
 * Decompiled with CFR 0.152.
 */
package nodream.nodream.Sleep;

import nodream.nodream.Config.NoDreamConfig;
import nodream.nodream.Sleep.TimeSet;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Sleep
implements Listener {
    private int playersSleeping = 0;
    private int playersMax = 0;
    private long time = 0L;
    private float currentPlayersPercentage;
    private Plugin plugin_;
    private BukkitTask timeTask;

    public Sleep(Plugin plugin) {
        this.plugin_ = plugin;
    }

    @EventHandler
    public void inBed(PlayerBedEnterEvent e) {
        if (e.getBedEnterResult() == PlayerBedEnterEvent.BedEnterResult.OK && e.getPlayer().getWorld().getEnvironment() == World.Environment.NORMAL) {
            this.countPlayers(e.getPlayer(), 1);
            if (this.currentPlayersPercentage >= (float)NoDreamConfig.getPlayersPercentage()) {
                if (NoDreamConfig.isDoDisplayMsg()) {
                    this.displayMessage(e.getPlayer(), 2);
                }
                this.timeTask = new TimeSet(e.getPlayer(), this.plugin_).runTaskLater(this.plugin_, 100L);
            } else if (NoDreamConfig.isDoDisplayMsg()) {
                this.displayMessage(e.getPlayer(), 0);
            }
        }
    }

    @EventHandler
    public void outBed(PlayerBedLeaveEvent e) {
        this.countPlayers(e.getPlayer(), 0);
        if (this.currentPlayersPercentage < (float)NoDreamConfig.getPlayersPercentage() && this.timeTask != null) {
            this.timeTask.cancel();
        }
        if (NoDreamConfig.isDoDisplayMsg()) {
            this.displayMessage(e.getPlayer(), 1);
        }
    }

    private int playersNeededPercentage() {
        this.currentPlayersPercentage = (float)this.playersSleeping / (float)this.playersMax * 100.0f;
        return (int)Math.ceil(((float)NoDreamConfig.getPlayersPercentage() - this.currentPlayersPercentage) * (float)this.playersMax / 100.0f);
    }

    private void countPlayers(Player p, int startingValue) {
        int playersSleeping_ = startingValue;
        int playersMax_ = 0;
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (player.getWorld().getEnvironment() != World.Environment.NORMAL) continue;
            if (player.isSleeping() && p != player) {
                ++playersSleeping_;
            }
            ++playersMax_;
        }
        this.playersMax = playersMax_;
        this.playersSleeping = playersSleeping_;
        this.playersNeededPercentage();
    }

    private void displayMessage(Player p, int msgValue) {
        this.time = p.getWorld().getTime() % 24000L;
        ChatColor c = ChatColor.GRAY;
        ChatColor c2 = ChatColor.DARK_AQUA;
        if (p.getWorld().isThundering() || this.time >= 12000L && this.time <= 24000L) {
            switch (msgValue) {
                case 0: {
                    if (this.playersNeededPercentage() == 1) {
                        this.plugin_.getServer().broadcastMessage(c2 + p.getDisplayName() + c + " " + NoDreamConfig.getIsSleepingMsg() + " " + c2 + this.playersNeededPercentage() + " " + NoDreamConfig.getPlayerNeeded());
                        break;
                    }
                    this.plugin_.getServer().broadcastMessage(c2 + p.getDisplayName() + c + " " + NoDreamConfig.getIsSleepingMsg() + " " + c2 + this.playersNeededPercentage() + " " + NoDreamConfig.getPlayersNeeded());
                    break;
                }
                case 1: {
                    if (this.playersNeededPercentage() == 1) {
                        this.plugin_.getServer().broadcastMessage(c2 + p.getDisplayName() + c + " " + NoDreamConfig.getIsNotSleepingMsg() + " " + c2 + this.playersNeededPercentage() + " " + NoDreamConfig.getPlayerNeeded());
                        break;
                    }
                    if (this.playersNeededPercentage() == 0) {
                        this.plugin_.getServer().broadcastMessage(c2 + p.getDisplayName() + c + " " + NoDreamConfig.getIsNotSleepingMsg());
                        break;
                    }
                    this.plugin_.getServer().broadcastMessage(c2 + p.getDisplayName() + c + " " + NoDreamConfig.getIsNotSleepingMsg() + " " + c2 + this.playersNeededPercentage() + " " + NoDreamConfig.getPlayersNeeded());
                    break;
                }
                case 2: {
                    this.plugin_.getServer().broadcastMessage(c2 + p.getDisplayName() + c + " " + NoDreamConfig.getIsSleepingMsg());
                    break;
                }
            }
        }
    }
}

