/*
 * Decompiled with CFR 0.152.
 */
package primescore.nexlock;

import java.util.Iterator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import primescore.nexlock.BlockDataFile;
import primescore.nexlock.LockUser;
import primescore.nexlock.Messages;
import primescore.nexlock.NexLock;

public class BlockListener
implements Listener {
    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        Block block = e.getBlock();
        BlockDataFile blockDataFile = NexLock.getBlockDataFile();
        String blockID = BlockDataFile.getBlockID(block);
        Player p = e.getPlayer();
        if (this.checkLocked(blockID, blockDataFile)) {
            e.setCancelled(true);
            p.sendMessage(Messages.destroy);
        }
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent e) {
        if (e.getInitiator().getLocation().getBlock().getType().equals((Object)Material.HOPPER) && NexLock.getLockableBlocks().contains(e.getSource().getLocation().getBlock().getType())) {
            BlockDataFile blockDataFile = NexLock.getBlockDataFile();
            String locationID = BlockDataFile.getLocationID(e.getSource().getLocation());
            if (this.checkLocked(locationID, blockDataFile)) {
                e.getInitiator().getLocation().getBlock().breakNaturally();
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        Block block = e.getBlock();
        Player player = e.getPlayer();
        LockUser user = NexLock.getUserHash().get(player);
        BlockDataFile blockDataFile = NexLock.getBlockDataFile();
        String blockID = BlockDataFile.getBlockID(block);
        user.resetAll();
        if (NexLock.getLockableBlocks().contains(block.getType())) {
            if (user.getAutoModeState()) {
                if (!block.getType().equals((Object)Material.CHEST) && !block.getType().equals((Object)Material.TRAPPED_CHEST)) {
                    blockDataFile.setBlockOwner(blockID, player.getUniqueId().toString());
                    player.sendMessage(Messages.added_lock);
                } else if (this.checkAlone(block)) {
                    blockDataFile.setBlockOwner(blockID, player.getUniqueId().toString());
                    player.sendMessage(Messages.added_lock);
                } else {
                    this.effectSurroundingChests(blockID, blockDataFile, player.getUniqueId().toString(), block, "extend", player, user);
                }
            } else if (block.getType().equals((Object)Material.CHEST) || block.getType().equals((Object)Material.TRAPPED_CHEST)) {
                this.effectSurroundingChests(blockID, blockDataFile, player.getUniqueId().toString(), block, "extend", player, user);
            }
        }
    }

    @EventHandler
    public void onBlockExplode(EntityExplodeEvent e) {
        List blocks = e.blockList();
        Iterator it = blocks.iterator();
        while (it.hasNext()) {
            Block examined_block = (Block)it.next();
            if (!NexLock.getLockableBlocks().contains(examined_block.getType())) continue;
            BlockDataFile blockDataFile = NexLock.getBlockDataFile();
            String blockID = BlockDataFile.getBlockID(examined_block);
            if (!this.checkLocked(blockID, blockDataFile)) continue;
            it.remove();
        }
    }

    @EventHandler
    public void onBlockInteract(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        String UUID2 = player.getUniqueId().toString();
        LockUser user = NexLock.getUserHash().get(player);
        Block blockClicked = e.getClickedBlock();
        BlockDataFile blockDataFile = NexLock.getBlockDataFile();
        String blockID = BlockDataFile.getBlockID(blockClicked);
        if (NexLock.getLockableBlocks().contains(blockClicked.getType())) {
            List blockStringList;
            if (user.getLockState()) {
                if (!this.checkLocked(blockID, blockDataFile)) {
                    blockDataFile.setBlockOwner(blockID, UUID2);
                    player.sendMessage(Messages.added_lock);
                    if (blockClicked.getType().equals((Object)Material.CHEST) || blockClicked.getType().equals((Object)Material.TRAPPED_CHEST)) {
                        this.effectSurroundingChests(blockID, blockDataFile, UUID2, blockClicked, "lock", player, user);
                    }
                } else {
                    player.sendMessage(Messages.locked);
                    e.setCancelled(true);
                }
            } else if (user.getUnlockState()) {
                if (this.checkLocked(blockID, blockDataFile)) {
                    if (blockDataFile.getBlockOwner(blockID).equals(UUID2)) {
                        player.sendMessage(Messages.unlocked);
                        blockDataFile.removeBlock(blockID);
                        if (blockClicked.getType().equals((Object)Material.CHEST) || blockClicked.getType().equals((Object)Material.TRAPPED_CHEST)) {
                            this.effectSurroundingChests(blockID, blockDataFile, UUID2, blockClicked, "unlock", player, user);
                        }
                    } else {
                        player.sendMessage(Messages.not_owner);
                        e.setCancelled(true);
                    }
                } else {
                    player.sendMessage(Messages.not_locked);
                }
            } else if (user.getRemoveAllState()) {
                if (this.checkLocked(blockID, blockDataFile)) {
                    if (blockDataFile.getBlockOwner(blockID).equals(UUID2)) {
                        blockDataFile.removeAllGuests(blockID);
                        this.effectSurroundingChests(blockID, blockDataFile, UUID2, blockClicked, "removeallguests", player, user);
                        if (blockClicked.getType().equals((Object)Material.CHEST) || blockClicked.getType().equals((Object)Material.TRAPPED_CHEST)) {
                            Chest chest = (Chest)blockClicked.getState();
                            List humanList = chest.getBlockInventory().getViewers();
                            player.sendMessage(Messages.removed_guests);
                            for (HumanEntity human : humanList) {
                                human.closeInventory();
                            }
                        }
                    } else {
                        player.sendMessage(Messages.not_owner);
                        e.setCancelled(true);
                    }
                } else {
                    player.sendMessage(Messages.not_locked);
                }
            } else if (user.getRemoveGuestState()) {
                if (this.checkLocked(blockID, blockDataFile)) {
                    if (blockDataFile.getBlockOwner(blockID).equals(UUID2)) {
                        blockDataFile.removeFromGuestList(blockID, user.getGuestList());
                        player.sendMessage(Messages.removed_guests);
                        this.effectSurroundingChests(blockID, blockDataFile, UUID2, blockClicked, "removeguestlist", player, user);
                        if (blockClicked.getType().equals((Object)Material.CHEST) || blockClicked.getType().equals((Object)Material.TRAPPED_CHEST)) {
                            Chest chest = (Chest)blockClicked.getState();
                            List humanList = chest.getBlockInventory().getViewers();
                            List blockStringList2 = blockDataFile.getConfigFile().getStringList(String.valueOf(blockID) + ".Guests");
                            for (HumanEntity human : humanList) {
                                if (blockStringList2.contains(human.getUniqueId().toString())) continue;
                                human.closeInventory();
                            }
                        }
                    } else {
                        player.sendMessage(Messages.not_owner);
                        e.setCancelled(true);
                    }
                } else {
                    player.sendMessage(Messages.not_locked);
                }
            } else if (user.getAddGuestState()) {
                if (this.checkLocked(blockID, blockDataFile)) {
                    if (blockDataFile.getBlockOwner(blockID).equals(UUID2)) {
                        blockDataFile.addToGuestList(blockID, user.getGuestList());
                        player.sendMessage(Messages.added_guests);
                        this.effectSurroundingChests(blockID, blockDataFile, UUID2, blockClicked, "updateguestlist", player, user);
                    } else {
                        player.sendMessage(Messages.not_owner);
                        e.setCancelled(true);
                    }
                } else {
                    player.sendMessage(Messages.not_locked);
                }
            } else if (e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && blockDataFile.getConfigFile().get(String.valueOf(blockID) + "." + "Owner") != null && !blockDataFile.getConfigFile().getString(String.valueOf(blockID) + "." + "Owner").equals(UUID2) && !(blockStringList = blockDataFile.getConfigFile().getStringList(String.valueOf(blockID) + ".Guests")).contains(player.getUniqueId().toString())) {
                e.setCancelled(true);
                player.sendMessage(Messages.locked);
            }
        }
    }

    public boolean checkLocked(String locationID, BlockDataFile blockDataFile) {
        return blockDataFile.getConfigFile().get(String.valueOf(locationID) + "." + "Owner") != null;
    }

    public void effectSurroundingChests(String locationID, BlockDataFile blockDataFile, String UUID2, Block blockClicked, String action, Player player, LockUser user) {
        int i = 0;
        while (i < 4) {
            Block directionalBlock;
            if (i == 0) {
                directionalBlock = blockClicked.getRelative(BlockFace.NORTH);
                this.checkBlock(locationID, blockDataFile, UUID2, blockClicked, action, player, user, directionalBlock);
            }
            if (i == 1) {
                directionalBlock = blockClicked.getRelative(BlockFace.EAST);
                this.checkBlock(locationID, blockDataFile, UUID2, blockClicked, action, player, user, directionalBlock);
            }
            if (i == 2) {
                directionalBlock = blockClicked.getRelative(BlockFace.SOUTH);
                this.checkBlock(locationID, blockDataFile, UUID2, blockClicked, action, player, user, directionalBlock);
            }
            if (i == 3) {
                directionalBlock = blockClicked.getRelative(BlockFace.WEST);
                this.checkBlock(locationID, blockDataFile, UUID2, blockClicked, action, player, user, directionalBlock);
            }
            ++i;
        }
    }

    public void checkBlock(String locationID, BlockDataFile blockDataFile, String UUID2, Block blockClicked, String action, Player player, LockUser user, Block directionalBlock) {
        if (directionalBlock.getType().equals((Object)blockClicked.getType())) {
            this.setBlock(directionalBlock, action, blockDataFile, UUID2, player, user, blockClicked);
        }
    }

    public void setBlock(Block newlyObtainedBlock, String action, BlockDataFile blockDataFile, String UUID2, Player player, LockUser user, Block placed) {
        String newlyObtainedID = BlockDataFile.getBlockID(newlyObtainedBlock);
        String placedID = BlockDataFile.getBlockID(placed);
        if (action.equals("lock")) {
            blockDataFile.setBlockOwner(newlyObtainedID, UUID2);
        }
        if (action.equals("unlock")) {
            blockDataFile.removeBlock(newlyObtainedID);
        }
        if (action.equals("removeallguests")) {
            blockDataFile.removeAllGuests(newlyObtainedID);
        }
        if (action.equals("updateguestlist")) {
            blockDataFile.addToGuestList(newlyObtainedID, user.getGuestList());
        }
        if (action.equals("removeguestlist")) {
            blockDataFile.removeFromGuestList(newlyObtainedID, user.getGuestList());
        }
        if (action.equals("extend")) {
            if (this.checkLocked(newlyObtainedID, blockDataFile)) {
                player.sendMessage(Messages.lock_extended);
                blockDataFile.setBlockOwner(placedID, blockDataFile.getBlockOwner(newlyObtainedID));
                blockDataFile.extendBlock(newlyObtainedID, placedID);
            } else {
                player.sendMessage(Messages.added_lock);
                blockDataFile.setBlockOwner(placedID, UUID2);
                blockDataFile.setBlockOwner(newlyObtainedID, UUID2);
            }
        }
    }

    public boolean checkAlone(Block blockClicked) {
        Block directionalBlock = blockClicked;
        int i = 0;
        while (i < 4) {
            if (i == 0) {
                directionalBlock = blockClicked.getRelative(BlockFace.NORTH);
            }
            if (i == 1) {
                directionalBlock = blockClicked.getRelative(BlockFace.EAST);
            }
            if (i == 2) {
                directionalBlock = blockClicked.getRelative(BlockFace.SOUTH);
            }
            if (i == 3) {
                directionalBlock = blockClicked.getRelative(BlockFace.WEST);
            }
            if (directionalBlock.getType().equals((Object)blockClicked.getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

