/*
 * Decompiled with CFR 0.152.
 */
package primescore.nexlock;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import primescore.nexlock.AbstractFile;
import primescore.nexlock.NexLock;

public class BlockDataFile
extends AbstractFile {
    public BlockDataFile(NexLock secure) {
        super(secure, "blockdata.yml");
    }

    public String getBlockOwner(String blockID) {
        return NexLock.getBlockDataFile().getConfigFile().getString(String.valueOf(blockID) + "." + "Owner");
    }

    public List<String> getGuests(String blockID) {
        return NexLock.getBlockDataFile().getConfigFile().getStringList(String.valueOf(blockID) + "." + "Guests");
    }

    public void setBlockOwner(String blockID, String OwnerUUID) {
        NexLock.getBlockDataFile().getConfigFile().set(String.valueOf(blockID) + "." + "Owner", (Object)OwnerUUID);
    }

    public void removeBlock(String location) {
        NexLock.getBlockDataFile().getConfigFile().set(location, null);
    }

    public void removeAllGuests(String location) {
        NexLock.getBlockDataFile().getConfigFile().set(String.valueOf(location) + ".Guests", null);
    }

    public void extendBlock(String location1, String location2) {
        List uuidList = NexLock.getBlockDataFile().getConfigFile().getStringList(String.valueOf(location1) + ".Guests");
        NexLock.getBlockDataFile().getConfigFile().set(String.valueOf(location2) + ".Guests", (Object)uuidList);
    }

    public static String getBlockID(Block block) {
        Location location = block.getLocation();
        return String.valueOf(String.valueOf(location.getBlockX())) + String.valueOf(location.getBlockY()) + String.valueOf(location.getBlockZ());
    }

    public static String getLocationID(Location location) {
        return String.valueOf(String.valueOf(location.getBlockX())) + String.valueOf(location.getBlockY()) + String.valueOf(location.getBlockZ());
    }

    public void addToGuestList(String location, List<OfflinePlayer> newGuests) {
        List uuidList = NexLock.getBlockDataFile().getConfigFile().getStringList(String.valueOf(location) + ".Guests");
        for (OfflinePlayer theNewGuest : newGuests) {
            if (uuidList.contains(theNewGuest.getUniqueId().toString())) continue;
            uuidList.add(theNewGuest.getUniqueId().toString());
        }
        NexLock.getBlockDataFile().getConfigFile().set(String.valueOf(location) + ".Guests", (Object)uuidList);
    }

    public void removeFromGuestList(String location, List<OfflinePlayer> newGuests) {
        List uuidList = NexLock.getBlockDataFile().getConfigFile().getStringList(String.valueOf(location) + ".Guests");
        for (OfflinePlayer theGoneGuest : newGuests) {
            if (!uuidList.contains(theGoneGuest.getUniqueId().toString())) continue;
            uuidList.remove(theGoneGuest.getUniqueId().toString());
        }
        NexLock.getBlockDataFile().getConfigFile().set(String.valueOf(location) + ".Guests", (Object)uuidList);
    }
}

