/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.lucko.networkinterceptor.NetworkInterceptorCommand;
import me.lucko.networkinterceptor.bstats.charts.SimplePie;
import me.lucko.networkinterceptor.bstats.velocity.Metrics;
import me.lucko.networkinterceptor.common.AbstractConfiguration;
import me.lucko.networkinterceptor.common.CommonNetworkInterceptor;
import me.lucko.networkinterceptor.common.NetworkInterceptorPlugin;
import me.lucko.networkinterceptor.common.Platform;
import me.lucko.networkinterceptor.common.PluginManager;
import me.lucko.networkinterceptor.velocity.VelictyLoggerWrapper;
import me.lucko.networkinterceptor.velocity.VelocityConfiguration;
import me.lucko.networkinterceptor.velocity.VelocityPluginManager;
import org.slf4j.Logger;

@Plugin(id="networkinterceptor", name="NetworkInterceptor", version="3.4.0", description="Plugin to monitor and block outgoing network requests", authors={"drives_a_ford"}, dependencies={@Dependency(id="luckperms", optional=true)})
public class VelocityNetworkInterceptor
implements NetworkInterceptorPlugin<PluginContainer> {
    private static final String SAMPLE_ALLOW_CONFIG_FILE_NAME = "sample-allow-config.yml";
    private static final String SAMPLE_DENY_CONFIG_FILE_NAME = "sample-deny-config.yml";
    private final ProxyServer server;
    private final Logger logger;
    private final VelictyLoggerWrapper loggerWrapper;
    private final Path dataDirectory;
    private final CommonNetworkInterceptor<VelocityNetworkInterceptor, PluginContainer> delegate;
    private VelocityConfiguration config;
    private final Metrics.Factory metricsFactory;
    private boolean isStartup = true;
    private VelocityPluginManager pluginManager;
    private List<RepeatingTaskInfo> repeatingTasksToSchedule = new ArrayList<RepeatingTaskInfo>();

    @Inject
    public VelocityNetworkInterceptor(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.loggerWrapper = new VelictyLoggerWrapper(this, this.logger);
        this.saveDefaultConfig();
        this.saveResource(SAMPLE_ALLOW_CONFIG_FILE_NAME);
        this.saveResource(SAMPLE_DENY_CONFIG_FILE_NAME);
        this.reloadConfig();
        this.delegate = new CommonNetworkInterceptor(this);
        this.metricsFactory = metricsFactory;
        this.pluginManager = new VelocityPluginManager(this.getServer().getPluginManager());
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.onEnable();
        boolean useMetrics = this.getConfiguration().getBoolean("enable-metrics", true);
        if (useMetrics) {
            int pluginId = 12197;
            Metrics metrics = this.metricsFactory.make(this, pluginId);
            metrics.addCustomChart(new SimplePie("mode", () -> this.config.getString("mode", "N/A")));
        }
        this.getLogger().info(useMetrics ? "bStats metrics enabled" : "bStats metrics disabled");
        CommandManager commandManager = this.server.getCommandManager();
        CommandMeta meta = commandManager.metaBuilder("networkinterceptorvelocity").aliases(new String[]{"niv"}).build();
        commandManager.register(meta, (Command)new NetworkInterceptorCommand<PluginContainer>(this).asVelocityCommand());
        this.isStartup = false;
        for (RepeatingTaskInfo info : this.repeatingTasksToSchedule) {
            this.runRepeatingTask(info.runnable, info.ticks);
        }
        this.repeatingTasksToSchedule.clear();
    }

    @Override
    public void saveDefaultConfig() {
        this.saveResource("config.yml");
    }

    public void saveResource(String fileName) {
        File file;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(file = new File(this.getDataFolder(), fileName)).exists()) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);){
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File getConfigFile() {
        return new File(this.getDataFolder(), "config.yml");
    }

    @Override
    public AbstractConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void reloadConfig() {
        try {
            this.config = new VelocityConfiguration(this.getConfigFile());
        }
        catch (FileNotFoundException e) {
            this.logger.warn("Unable to initialize config: ", (Throwable)e);
        }
    }

    @Override
    public java.util.logging.Logger getLogger() {
        return this.loggerWrapper;
    }

    @Override
    public void onEnable() {
        this.delegate.onEnable();
    }

    @Override
    public void onDisable() {
        this.delegate.onDisable();
    }

    @Override
    public void disablePlugin() {
        this.getLogger().severe("Plugin should now disable but I am unaware as to how this should be done");
    }

    @Override
    public File getDataFolder() {
        return this.dataDirectory.toFile();
    }

    @Override
    public String getServerVersion() {
        return "Velocity " + this.server.getVersion().getVersion();
    }

    @Override
    public String getPluginVersion() {
        return "3.4.0";
    }

    @Override
    public void runTaskLater(Runnable runnable, long ticks) {
        this.server.getScheduler().buildTask((Object)this, runnable).delay(ticks * 50L, TimeUnit.MILLISECONDS).schedule();
    }

    public void runRepeatingTask(Runnable runnable, long ticks) {
        if (this.isStartup) {
            this.repeatingTasksToSchedule.add(new RepeatingTaskInfo(runnable, ticks));
            return;
        }
        this.server.getScheduler().buildTask((Object)this, runnable).repeat(ticks * 50L, TimeUnit.MILLISECONDS).delay(ticks * 50L, TimeUnit.MILLISECONDS).schedule();
    }

    @Override
    public Platform getPlatformType() {
        return Platform.VELOCITY;
    }

    @Override
    public CommonNetworkInterceptor<VelocityNetworkInterceptor, PluginContainer> getDelegate() {
        return this.delegate;
    }

    @Override
    public PluginContainer asPlugin() {
        return (PluginContainer)this.server.getPluginManager().getPlugin("networkinterceptor").get();
    }

    @Override
    public void reload() {
        this.reloadConfig();
        this.delegate.disable();
        try {
            this.delegate.enable();
        }
        catch (CommonNetworkInterceptor.IllegalConfigStateException e) {
            this.getLogger().severe(e.getMessage());
            this.getLogger().severe("Disabling plugin");
            this.disablePlugin();
        }
    }

    public ProxyServer getServer() {
        return this.server;
    }

    @Override
    public PluginManager<PluginContainer> getNIPluginManager() {
        return this.pluginManager;
    }

    private class RepeatingTaskInfo {
        private final Runnable runnable;
        private final long ticks;

        public RepeatingTaskInfo(Runnable runnable, long ticks) {
            this.runnable = runnable;
            this.ticks = ticks;
        }
    }
}

