/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.velocity;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.lucko.networkinterceptor.common.AbstractConfiguration;
import org.yaml.snakeyaml.Yaml;

public class VelocityConfiguration
implements AbstractConfiguration {
    private static final String DELIMITER = ".";
    private final String currentPath;
    private final String name;
    private final Map<String, Object> map;

    public VelocityConfiguration(File file) throws FileNotFoundException {
        this((Map)new Yaml().load((InputStream)new FileInputStream(file)), "");
    }

    private VelocityConfiguration(Map<String, Object> map, String currentPath) {
        this.map = map;
        this.currentPath = currentPath;
        String[] split = currentPath.split(Pattern.quote(DELIMITER));
        this.name = split[split.length - 1];
    }

    @Override
    public Collection<String> getKeys(boolean deep) {
        if (deep) {
            throw new IllegalStateException("Deep keys are not supported at this time");
        }
        return this.map.keySet();
    }

    @Override
    public Map<String, Object> getValues(boolean deep) {
        if (!deep) {
            throw new IllegalStateException("Shallow values are not supported at this time");
        }
        return this.map;
    }

    @Override
    public boolean contains(String path) {
        Map curMap = this.map;
        Object result = null;
        String[] split = path.split(Pattern.quote(DELIMITER));
        int counter = 0;
        for (String curPath : split) {
            ++counter;
            result = curMap.get(curPath);
            if (!(result instanceof Map)) {
                return counter >= split.length;
            }
            curMap = (Map)result;
        }
        return true;
    }

    @Override
    public boolean contains(String path, boolean ignoreDefault) {
        return this.contains(path);
    }

    @Override
    public boolean isSet(String path) {
        return this.contains(path);
    }

    @Override
    public String getCurrentPath() {
        return this.currentPath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object get(String path) {
        Map curMap = this.map;
        Object result = null;
        String[] split = path.split(Pattern.quote(DELIMITER));
        int counter = 0;
        for (String curPath : split) {
            ++counter;
            result = curMap.get(curPath);
            if (!(result instanceof Map)) {
                if (counter < split.length) {
                    return null;
                }
                return result;
            }
            curMap = (Map)result;
        }
        return result;
    }

    @Override
    public Object get(String path, Object def) {
        Object o = this.get(path);
        return o == null ? def : o;
    }

    @Override
    public String getString(String path) {
        Object o = this.get(path);
        return o == null ? null : String.valueOf(o);
    }

    @Override
    public String getString(String path, String def) {
        String str = this.getString(path);
        return str == null ? def : str;
    }

    @Override
    public int getInt(String path) {
        return this.getInt(path, 0);
    }

    @Override
    public int getInt(String path, int def) {
        if (!this.contains(path)) {
            return def;
        }
        try {
            return Integer.parseInt(this.getString(path));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public boolean getBoolean(String path) {
        return this.getBoolean(path, false);
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        if (!this.contains(path)) {
            return def;
        }
        try {
            return Boolean.parseBoolean(this.getString(path));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public double getDouble(String path) {
        return this.getDouble(path, 0.0);
    }

    @Override
    public double getDouble(String path, double def) {
        if (!this.contains(path)) {
            return def;
        }
        try {
            return Double.parseDouble(this.getString(path));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public long getLong(String path) {
        return this.getLong(path, 0L);
    }

    @Override
    public long getLong(String path, long def) {
        if (!this.contains(path)) {
            return def;
        }
        try {
            return Long.parseLong(this.getString(path));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public List<?> getList(String path) {
        if (!this.contains(path)) {
            return null;
        }
        Object o = this.get(path);
        if (o instanceof List) {
            return (List)o;
        }
        return null;
    }

    @Override
    public List<?> getList(String path, List<?> def) {
        List<?> list = this.getList(path);
        return list == null ? def : list;
    }

    @Override
    public List<String> getStringList(String path) {
        List<String> list = this.getList(path);
        if (list == null || list.isEmpty()) {
            return new ArrayList<String>();
        }
        if (list.get(0) instanceof String) {
            return list;
        }
        return new ArrayList<String>();
    }

    @Override
    public AbstractConfiguration getConfigurationSection(String path) {
        Object res = this.get(path);
        if (res instanceof Map) {
            return new VelocityConfiguration((Map)res, this.currentPath + DELIMITER + path);
        }
        return null;
    }
}

