/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.plugin;

import me.lucko.networkinterceptor.plugin.PluginOptions;

public class TrustedAndBlockedOptions<PLUGIN> {
    private final PluginOptions<PLUGIN> trusted;
    private final PluginOptions<PLUGIN> blocked;

    public TrustedAndBlockedOptions(PluginOptions<PLUGIN> trusted, PluginOptions<PLUGIN> blocked) {
        Validate.isTrue(trusted.getKeepType() == blocked.getKeepType(), "Need keep types to be the same");
        Validate.isTrue(trusted.shouldAllowNonPlugin() == blocked.shouldAllowNonPlugin(), "Need non-plugin behaviour to be the same");
        Validate.isTrue(trusted.trust, "First argument should be trusted, second untrusted");
        Validate.isTrue(!blocked.trust, "First argument should be trusted, second untrusted");
        this.trusted = trusted;
        this.blocked = blocked;
    }

    public boolean isTrusted(PLUGIN plugin) {
        return this.trusted.isTrusted(plugin) && this.blocked.isTrusted(plugin);
    }

    public PluginOptions<PLUGIN> getTrustedOptions() {
        return this.trusted;
    }

    public PluginOptions<PLUGIN> getBlockedOptions() {
        return this.blocked;
    }

    private static class Validate {
        private Validate() {
        }

        public static void isTrue(boolean val, String msg) {
            if (!val) {
                throw new IllegalStateException(msg);
            }
        }
    }
}

