/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.lucko.networkinterceptor.common.NetworkInterceptorPlugin;
import me.lucko.networkinterceptor.plugin.KeepPlugins;

public abstract class PluginOptions<PLUGIN> {
    private final KeepPlugins keepType;
    private final boolean allowNonPlugin;
    private final Set<String> allTrustedPluginNames;
    private final Set<String> pluginNames;
    protected final Set<PLUGIN> plugins = new HashSet<PLUGIN>();
    protected final boolean trust;

    public PluginOptions(KeepPlugins keepType, boolean allowNonPlugin, Set<String> plugins, boolean trust) {
        this.keepType = keepType;
        this.allowNonPlugin = allowNonPlugin;
        this.allTrustedPluginNames = new HashSet<String>(plugins);
        this.pluginNames = plugins;
        this.trust = trust;
    }

    public void searchForPlugins(NetworkInterceptorPlugin<PLUGIN> owner) {
        List<String> toBeLoaded = this.findAndAddPlugins(this.pluginNames, owner);
        if (!toBeLoaded.isEmpty()) {
            owner.runTaskLater(() -> {
                List<String> residual = this.findAndAddPlugins(toBeLoaded, owner);
                if (!residual.isEmpty()) {
                    for (String name : residual) {
                        owner.getLogger().warning("Unable to find plugin: " + name);
                    }
                }
            }, 1L);
        }
    }

    private List<String> findAndAddPlugins(Collection<String> pluginNames, NetworkInterceptorPlugin<PLUGIN> owner) {
        ArrayList<String> remainder = new ArrayList<String>();
        for (String name : pluginNames) {
            if (this.attemptAddPlugin(name)) continue;
            remainder.add(name);
        }
        return remainder;
    }

    protected abstract boolean attemptAddPlugin(String var1);

    public KeepPlugins getKeepType() {
        return this.keepType;
    }

    public boolean shouldAllowNonPlugin() {
        return this.allowNonPlugin;
    }

    public boolean isTrusted(PLUGIN plugin) {
        return this.plugins.contains(plugin) == this.trust;
    }

    public boolean isListedAsTrustedPluginName(String pluginName) {
        if (!this.trust) {
            return !this.allTrustedPluginNames.contains(pluginName);
        }
        return this.allTrustedPluginNames.contains(pluginName);
    }

    public Set<String> getPluginNames() {
        return Collections.unmodifiableSet(this.pluginNames);
    }
}

