/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.plugin;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class ManualPluginOptions {
    private final Map<String, String> packageToPluginNameMap = new HashMap<String, String>();
    private final boolean isEnabled;
    private final boolean disableAfterStartup;

    public ManualPluginOptions(ConfigurationSection section) {
        if (section == null) {
            this.isEnabled = false;
            this.disableAfterStartup = false;
            return;
        }
        this.isEnabled = section.getBoolean("enabled", false);
        this.disableAfterStartup = section.getBoolean("disable-after-startup", true);
        this.loadPackages(section.getConfigurationSection("plugins"));
    }

    private void loadPackages(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        for (String pluginName : section.getKeys(false)) {
            for (String packageName : section.getStringList(pluginName)) {
                this.packageToPluginNameMap.put(packageName, pluginName);
            }
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean disableAfterStartup() {
        return this.disableAfterStartup;
    }

    public boolean isEmpty() {
        return !this.isEnabled || this.packageToPluginNameMap.isEmpty();
    }

    public void clear() {
        this.packageToPluginNameMap.clear();
    }

    public String getPluginNameFor(String className) {
        for (String packageName : this.packageToPluginNameMap.keySet()) {
            if (!className.startsWith(packageName)) continue;
            return this.packageToPluginNameMap.get(packageName);
        }
        return null;
    }
}

