/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.loggers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import me.lucko.networkinterceptor.InterceptEvent;
import me.lucko.networkinterceptor.loggers.EventLogger;

public class CompositeLogger<PLUGIN>
implements EventLogger<PLUGIN> {
    private final List<EventLogger<PLUGIN>> loggers;

    @SafeVarargs
    public CompositeLogger(EventLogger<PLUGIN> ... loggers) {
        Preconditions.checkArgument((loggers.length != 0 ? 1 : 0) != 0, (Object)"no loggers specified");
        this.loggers = ImmutableList.copyOf((Object[])loggers);
    }

    @Override
    public void logAttempt(InterceptEvent<PLUGIN> event) {
        for (EventLogger<PLUGIN> logger : this.loggers) {
            try {
                logger.logAttempt(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void logBlock(InterceptEvent<PLUGIN> event) {
        for (EventLogger<PLUGIN> logger : this.loggers) {
            try {
                logger.logBlock(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

