/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.loggers;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import me.lucko.networkinterceptor.InterceptEvent;
import me.lucko.networkinterceptor.common.NetworkInterceptorPlugin;
import me.lucko.networkinterceptor.loggers.EventLogger;

public abstract class AbstractEventLogger<PLUGIN>
implements EventLogger<PLUGIN> {
    private final boolean includeTraces;
    private final NetworkInterceptorPlugin<PLUGIN> ni;

    protected AbstractEventLogger(boolean includeTraces, NetworkInterceptorPlugin<PLUGIN> ni) {
        this.includeTraces = includeTraces;
        this.ni = ni;
    }

    protected abstract Logger getLogger();

    @Override
    public void logAttempt(InterceptEvent<PLUGIN> event) {
        String host = event.getHost();
        StringBuilder sb = new StringBuilder("Intercepted connection to ").append(host);
        String origHost = event.getOriginalHost();
        if (origHost != null) {
            sb.append(" (").append(origHost).append(")");
        }
        this.appendPluginIfPossible(sb, event);
        sb.append("\n");
        if (this.includeTraces && !event.isRepeatCall()) {
            Map<StackTraceElement, PLUGIN> map = event.getNonInternalStackTraceWithPlugins();
            for (StackTraceElement element : map.keySet()) {
                sb.append("\tat ").append(element);
                PLUGIN providingPlugin = map.get(element);
                if (providingPlugin != null) {
                    String name = this.ni.getNIPluginManager().getName(providingPlugin);
                    sb.append(" [").append(name).append(']');
                }
                sb.append("\n");
            }
        } else if (this.includeTraces) {
            sb.append("\tat (identical stack trace omitted)\n");
        }
        sb.setLength(sb.length() - 1);
        this.getLogger().info(sb.toString());
    }

    private void appendPluginIfPossible(StringBuilder sb, InterceptEvent<PLUGIN> event) {
        PLUGIN trustedPlugin = event.getTrustedPlugin();
        PLUGIN blockedPlugin = event.getBlockedPlugin();
        Object target = null;
        if (trustedPlugin != null) {
            target = trustedPlugin;
            sb.append(" by trusted-plugin ");
        } else if (blockedPlugin != null) {
            target = blockedPlugin;
            sb.append(" by blocked-plugin ");
        } else {
            Set<PLUGIN> traced = event.getOrderedTracedPlugins();
            if (!traced.isEmpty()) {
                sb.append(" by plugin ");
                target = traced.iterator().next();
            }
        }
        if (target != null) {
            String name = this.ni.getNIPluginManager().getName(target);
            sb.append(name);
        }
    }

    @Override
    public void logBlock(InterceptEvent<PLUGIN> event) {
        StringBuilder sb = new StringBuilder("Blocked connection to ");
        sb.append(event.getHost());
        String origHost = event.getOriginalHost();
        if (origHost != null) {
            sb.append(" (").append(origHost).append(")");
        }
        this.appendPluginIfPossible(sb, event);
        this.getLogger().info(sb.toString());
    }
}

