/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.core.impl.utils.logging;

import java.util.function.Supplier;
import java.util.logging.Logger;
import me.lucko.networkinterceptor.core.api.utils.logger.SDCDebugLogger;
import me.lucko.networkinterceptor.core.api.utils.logger.SDCSpamStrategy;
import me.lucko.networkinterceptor.core.impl.utils.logging.AllowAllStrategy;

public class DebugLogger
implements SDCDebugLogger {
    private static final String DEFAULT_PREFIX = "DEBUG: ";
    private final Logger delegate;
    private final SDCSpamStrategy spamStrategy;
    private final String prefix;
    private final Supplier<Boolean> enableChecker;

    public DebugLogger(Logger delegate, Supplier<Boolean> enableChecker) {
        this(delegate, enableChecker, DEFAULT_PREFIX);
    }

    public DebugLogger(Logger delegate, Supplier<Boolean> enableChecker, String prefix) {
        this(delegate, enableChecker, new AllowAllStrategy(), prefix);
    }

    public DebugLogger(Logger delegate, Supplier<Boolean> enableChecker, SDCSpamStrategy spamStrategy) {
        this(delegate, enableChecker, spamStrategy, DEFAULT_PREFIX);
    }

    public DebugLogger(Logger delegate, Supplier<Boolean> enableChecker, SDCSpamStrategy spamStrategy, String prefix) {
        this.delegate = delegate;
        this.enableChecker = enableChecker;
        this.spamStrategy = spamStrategy;
        this.prefix = prefix;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isEnabled() {
        return this.enableChecker.get();
    }

    @Override
    public void log(String msg) {
        if (this.isEnabled() && this.spamStrategy.shouldSend(msg)) {
            this.delegate.warning(this.prefix + msg);
        }
    }
}

