/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.core.impl.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.Validate;

public class Paginator<T>
implements Iterable<T> {
    private final List<T> list;
    private final int page;
    private final int perPage;
    private final int pageStart;
    private final int pageEnd;

    public Paginator(List<T> list, int page, int perPage) {
        Validate.isTrue((page > 0 ? 1 : 0) != 0, (String)"Page needs to be positive", (Object[])new Object[0]);
        this.list = list;
        this.page = page;
        this.perPage = perPage;
        Validate.isTrue((boolean)this.validPage(), (String)"Does not have page", (Object[])new Object[0]);
        Validate.isTrue((perPage > 0 ? 1 : 0) != 0, (String)"Need to have a positive number of items per page", (Object[])new Object[0]);
        this.pageStart = Paginator.getPageStart(this.page, this.perPage);
        this.pageEnd = Math.min(Paginator.getPageEnd(this.page, this.perPage), this.list.size());
    }

    private boolean validPage() {
        if (this.page == 1) {
            return true;
        }
        int pageStart = Paginator.getPageStart(this.page, this.perPage);
        return pageStart < this.list.size();
    }

    public int getPage() {
        return this.page;
    }

    public boolean isPartial() {
        return this.getPageEnd() != Paginator.getPageEnd(this.page, this.perPage);
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getPageStart() {
        return this.pageStart;
    }

    public int getPageEnd() {
        return this.pageEnd;
    }

    public List<T> getOnPage() {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = this.pageStart; i < this.pageEnd; ++i) {
            list.add(this.list.get(i));
        }
        return list;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getOnPage().iterator();
    }

    public void paginate(Consumer<T> worker) {
        for (T t : this.getOnPage()) {
            worker.accept(t);
        }
    }

    public String toString() {
        return String.format("[Paginator: page %d with %d on page of %d length array, current %d-%d]", this.page, this.perPage, this.list.size(), this.pageStart, this.pageEnd);
    }

    public static int getPageStart(int page, int perPage) {
        return (page - 1) * perPage;
    }

    public static int getPageEnd(int page, int perPage) {
        return Paginator.getPageStart(page + 1, perPage);
    }

    public static boolean isValidPage(List<?> list, int page, int perPage) {
        try {
            new Paginator(list, page, perPage);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static <T> void paginate(List<T> list, int page, int perPage, Consumer<T> worker) {
        Paginator<T> paginator = new Paginator<T>(list, page, perPage);
        paginator.paginate(worker);
    }
}

