/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.core.impl.messaging.context.delegating;

import me.lucko.networkinterceptor.core.api.messaging.context.SDCSingleContext;
import org.apache.commons.lang3.Validate;

public class DelegatingMultipleToOneContext<T>
implements SDCSingleContext<T> {
    private final SDCSingleContext<T>[] delegates;
    private final T content;

    public DelegatingMultipleToOneContext(SDCSingleContext<T>[] delegates) {
        Validate.notEmpty((Object[])delegates, (String)"Need at least one delegte", (Object[])new Object[0]);
        this.content = delegates[0].getContents();
        for (int i = 1; i < delegates.length; ++i) {
            T other = delegates[i].getContents();
            Validate.isTrue((this.content == other ? 1 : 0) != 0, (String)"All contents should be the same", (Object[])new Object[0]);
        }
        this.delegates = delegates;
    }

    @Override
    public String fill(String msg) {
        for (SDCSingleContext<T> context : this.delegates) {
            msg = context.fill(msg);
        }
        return msg;
    }

    @Override
    public T getContents() {
        return this.content;
    }
}

