/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.core.impl.config;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import me.lucko.networkinterceptor.core.api.config.SDCConfiguration;
import me.lucko.networkinterceptor.core.api.config.SDCCustomConfig;
import me.lucko.networkinterceptor.core.api.config.exceptions.ConfigCreationException;
import me.lucko.networkinterceptor.core.api.config.exceptions.ConfigReloadException;
import me.lucko.networkinterceptor.core.api.config.exceptions.ConfigSaveException;
import me.lucko.networkinterceptor.core.api.wrappers.SDCResourceProvider;
import me.lucko.networkinterceptor.core.impl.config.ConfigurationWrapper;
import org.apache.commons.lang3.Validate;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class CustomYamlConfig
implements SDCCustomConfig {
    private final SDCResourceProvider resourceProvider;
    private final File file;
    private final boolean createWhenMissing;
    private YamlConfiguration customConfig;
    private ConfigurationWrapper wrapper;

    public CustomYamlConfig(SDCResourceProvider resourceProvider, File file) {
        this(resourceProvider, file, true);
    }

    public CustomYamlConfig(SDCResourceProvider resourceProvider, File file, boolean createWhenMissing) {
        this.resourceProvider = resourceProvider;
        this.file = file;
        this.createWhenMissing = createWhenMissing;
    }

    @Override
    public void reloadConfig() throws ConfigReloadException {
        if (this.createWhenMissing) {
            this.saveDefaultConfig();
        }
        this.customConfig = CustomYamlConfig.loadConfiguration(this.file);
        this.wrapper = new ConfigurationWrapper((ConfigurationSection)this.customConfig);
        InputStreamReader defConfigStream = null;
        InputStream resource = this.resourceProvider.getResource(this.file.getName());
        if (resource != null) {
            defConfigStream = new InputStreamReader(resource, Charsets.UTF_8);
        }
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration(defConfigStream);
            this.customConfig.setDefaults((Configuration)defConfig);
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public SDCConfiguration getConfig() {
        if (this.wrapper == null) {
            this.reloadConfig();
        }
        return this.wrapper;
    }

    @Override
    public void saveConfig() throws ConfigSaveException {
        if (this.customConfig == null) {
            return;
        }
        try {
            this.customConfig.save(this.file);
        }
        catch (IOException ex) {
            throw new ConfigSaveException(ex);
        }
    }

    @Override
    public void saveDefaultConfig() throws ConfigSaveException {
        if (!this.file.exists() && this.resourceProvider.getResource(this.file.getName()) != null) {
            this.resourceProvider.saveResource(this.file.getName(), false);
        }
    }

    public static YamlConfiguration loadConfiguration(File file) throws ConfigCreationException {
        Validate.notNull((Object)file, (String)"File cannot be null", (Object[])new Object[0]);
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException | InvalidConfigurationException ex) {
            throw new ConfigCreationException(ex);
        }
        return config;
    }
}

