/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.core.impl.config;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import me.lucko.networkinterceptor.core.api.SlimeDogPlugin;
import me.lucko.networkinterceptor.core.api.config.SDCCustomConfig;
import me.lucko.networkinterceptor.core.api.config.SDCCustomConfigManager;
import me.lucko.networkinterceptor.core.impl.config.CustomYamlConfig;

public class ConfigManager
implements SDCCustomConfigManager {
    private static final String DEFAULT_CONFIG_NAME = "config.yml";
    private final SlimeDogPlugin plugin;
    private final boolean createFilesFromDefault;
    private final Map<String, SDCCustomConfig> cachedConfigs = new HashMap<String, SDCCustomConfig>();

    public ConfigManager(SlimeDogPlugin plugin) {
        this(plugin, true);
    }

    public ConfigManager(SlimeDogPlugin plugin, boolean createFilesFromDefault) {
        this.plugin = plugin;
        this.createFilesFromDefault = createFilesFromDefault;
    }

    @Override
    public SDCCustomConfig getConfig(String fileName) {
        return this.getConfig(new File(this.plugin.getDataFolder(), fileName));
    }

    @Override
    public SDCCustomConfig getConfig(File file) throws IllegalArgumentException {
        File dataFolder = this.plugin.getDataFolder();
        Path dataFolderPath = dataFolder.toPath().toAbsolutePath();
        Path filePath = file.toPath().toAbsolutePath();
        if (!filePath.startsWith(dataFolderPath)) {
            throw new IllegalArgumentException("Cannot use custom configs for files not in the plugin data folder");
        }
        String fn = filePath.toString();
        if (this.cachedConfigs.containsKey(fn)) {
            return this.cachedConfigs.get(fn);
        }
        CustomYamlConfig yaml = new CustomYamlConfig(this.plugin.getResourceProvider(), file, this.createFilesFromDefault);
        this.cachedConfigs.put(fn, yaml);
        return yaml;
    }

    @Override
    public SDCCustomConfig getDefaultConfig() {
        SDCCustomConfig config = this.getConfig(DEFAULT_CONFIG_NAME);
        config.saveDefaultConfig();
        return config;
    }
}

