/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.core.impl.commands;

import java.util.List;
import java.util.Objects;
import me.lucko.networkinterceptor.core.api.commands.SDCCommandOption;
import me.lucko.networkinterceptor.core.api.commands.SDCCommandOptionSet;
import me.lucko.networkinterceptor.core.impl.commands.CommandOptionSet;

public class CommandOption
implements SDCCommandOption {
    private final String name;
    private final String raw;
    private final String value;

    public CommandOption(String raw, String value) {
        this.raw = raw;
        this.name = raw.replace("-", "");
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRaw() {
        return this.raw;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public String getValue() throws IllegalStateException {
        if (!this.hasValue()) {
            throw new IllegalStateException("This option provides no value");
        }
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommandOption)) {
            return false;
        }
        CommandOption o = (CommandOption)other;
        return o.name.equals(this.name) && (this.hasValue() ? this.value.equals(o.value) : !o.hasValue());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return String.format("{CmdOpt[%s=%s]}", this.raw, this.hasValue() ? this.value : "N/A");
    }

    public static SDCCommandOptionSet convertFromString(List<String> rawOptions) {
        CommandOptionSet options = new CommandOptionSet();
        for (String raw : rawOptions) {
            options.addOption(raw, null);
        }
        return options;
    }
}

