/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.core.impl.commands;

import java.util.ArrayList;
import java.util.List;
import me.lucko.networkinterceptor.core.api.commands.SDCCommandOptionSet;
import me.lucko.networkinterceptor.core.impl.commands.AbstractParentCommand;
import me.lucko.networkinterceptor.core.impl.commands.CommandOptionSet;
import me.lucko.networkinterceptor.core.impl.wrappers.BukkitAdapter;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public abstract class BukkitFacingParentCommand
extends AbstractParentCommand
implements TabExecutor {
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return this.onTabComplete(BukkitAdapter.adapt(sender), args);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        OptionParser opts = OptionParser.parseArgs(args);
        return this.onOptionedCommand(BukkitAdapter.adapt(sender), opts.args, opts.opts);
    }

    public static class OptionParser {
        private final String[] args;
        private final SDCCommandOptionSet opts;

        public OptionParser(String[] args, SDCCommandOptionSet opts) {
            this.args = args;
            this.opts = opts;
        }

        public String[] getArgs() {
            return this.args;
        }

        public SDCCommandOptionSet getOpts() {
            return this.opts;
        }

        public static OptionParser parseArgs(String[] args) {
            ArrayList<String> argList = new ArrayList<String>();
            CommandOptionSet opts = new CommandOptionSet();
            String curOpt = null;
            for (String arg : args) {
                if (arg.startsWith("--")) {
                    if (curOpt != null) {
                        opts.addOption(curOpt, null);
                    }
                    curOpt = arg;
                    continue;
                }
                if (curOpt != null) {
                    opts.addOption(curOpt, arg);
                    curOpt = null;
                    continue;
                }
                argList.add(arg);
            }
            if (curOpt != null) {
                opts.addOption(curOpt, null);
            }
            return new OptionParser(argList.toArray(new String[argList.size()]), opts);
        }
    }
}

