/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.common;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import me.lucko.networkinterceptor.InterceptEvent;
import me.lucko.networkinterceptor.blockers.AllowBlocker;
import me.lucko.networkinterceptor.blockers.BlockBlocker;
import me.lucko.networkinterceptor.blockers.Blocker;
import me.lucko.networkinterceptor.blockers.CompositeBlocker;
import me.lucko.networkinterceptor.blockers.LearningBlocker;
import me.lucko.networkinterceptor.blockers.ManualPluginDetectingBlocker;
import me.lucko.networkinterceptor.blockers.PluginAwareBlocker;
import me.lucko.networkinterceptor.bukkit.BukkitPluginOptions;
import me.lucko.networkinterceptor.bungee.BungeePluginOptions;
import me.lucko.networkinterceptor.common.AbstractConfiguration;
import me.lucko.networkinterceptor.common.NetworkInterceptorPlugin;
import me.lucko.networkinterceptor.common.Platform;
import me.lucko.networkinterceptor.interceptors.Interceptor;
import me.lucko.networkinterceptor.interceptors.ProxySelectorInterceptor;
import me.lucko.networkinterceptor.interceptors.SecurityManagerInterceptor;
import me.lucko.networkinterceptor.loggers.CompositeLogger;
import me.lucko.networkinterceptor.loggers.ConsoleLogger;
import me.lucko.networkinterceptor.loggers.EventLogger;
import me.lucko.networkinterceptor.loggers.FileLogger;
import me.lucko.networkinterceptor.plugin.KeepPlugins;
import me.lucko.networkinterceptor.plugin.ManualPluginOptions;
import me.lucko.networkinterceptor.plugin.PluginOptions;
import me.lucko.networkinterceptor.plugin.TrustedAndBlockedOptions;
import me.lucko.networkinterceptor.velocity.VelocityNetworkInterceptor;
import me.lucko.networkinterceptor.velocity.VelocityPluginOptions;
import net.md_5.bungee.api.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommonNetworkInterceptor<T extends NetworkInterceptorPlugin<PLUGIN>, PLUGIN> {
    private final T plugin;
    private final Map<InterceptMethod, Interceptor> interceptors = new EnumMap<InterceptMethod, Interceptor>(InterceptMethod.class);
    private EventLogger<PLUGIN> logger = null;
    private Blocker<PLUGIN> blocker = null;
    private TrustedAndBlockedOptions<PLUGIN> options = null;
    private boolean isOnStartup = true;
    private boolean ignoreAllowed = false;

    public CommonNetworkInterceptor(T plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.enable();
    }

    public void onEnable() {
        if (this.options != null) {
            this.options.getTrustedOptions().searchForPlugins((NetworkInterceptorPlugin<PLUGIN>)this.plugin);
            this.options.getBlockedOptions().searchForPlugins((NetworkInterceptorPlugin<PLUGIN>)this.plugin);
        }
        this.isOnStartup = false;
    }

    public void onDisable() {
        this.disable();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.disable();
        try {
            this.enable();
        }
        catch (IllegalConfigStateException e) {
            this.plugin.getLogger().severe(e.getMessage());
            this.plugin.getLogger().severe("Disabling plugin");
            this.plugin.disablePlugin();
        }
    }

    public void logAttempt(InterceptEvent<PLUGIN> event) {
        if (this.logger == null) {
            return;
        }
        if (this.ignoreAllowed && this.blocker instanceof AllowBlocker && !this.blocker.shouldBlock(event)) {
            return;
        }
        this.logger.logAttempt(event);
    }

    public void logBlock(InterceptEvent<PLUGIN> event) {
        if (this.logger == null) {
            return;
        }
        this.logger.logBlock(event);
    }

    public boolean shouldBlock(InterceptEvent<PLUGIN> event) {
        return this.blocker != null && this.blocker.shouldBlock(event);
    }

    public void enable() throws IllegalConfigStateException {
        AbstractConfiguration config = this.plugin.getConfiguration();
        this.setupBlockers(config);
        this.setupLoggers(config);
        this.setupInterceptors(config);
        for (Interceptor interceptor : this.interceptors.values()) {
            try {
                interceptor.enable();
            }
            catch (Exception e) {
                if (e instanceof AccessControlException && this.plugin.getPlatformType() == Platform.BUNGEE) {
                    this.plugin.getLogger().warning("Since bungee provides its own security manager, the Security Manager Interceptor is unable to be used with a Bungee instance");
                    return;
                }
                this.plugin.getLogger().log(Level.SEVERE, "Exception occurred whilst enabling " + interceptor.getClass().getName(), e);
            }
        }
    }

    public void disable() {
        for (Interceptor interceptor : this.interceptors.values()) {
            try {
                interceptor.disable();
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Exception occurred whilst disabling " + interceptor.getClass().getName(), e);
            }
        }
        this.interceptors.clear();
        if (this.blocker instanceof LearningBlocker) {
            ((LearningBlocker)this.blocker).clear();
        }
    }

    private void setupInterceptors(AbstractConfiguration configuration) {
        List<String> methods = configuration.getStringList("methods");
        if (methods.isEmpty()) {
            this.plugin.getLogger().info("No methods are defined");
            return;
        }
        EnumSet<InterceptMethod> enabled = EnumSet.noneOf(InterceptMethod.class);
        for (String string : new ArrayList<String>(methods)) {
            try {
                enabled.add(InterceptMethod.fromString(string));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().severe("Unknown method: " + string);
                methods.remove(string);
            }
        }
        this.plugin.getLogger().info("Interceptors: " + methods);
        for (InterceptMethod interceptMethod : enabled) {
            try {
                Constructor constructor = interceptMethod.clazz.getDeclaredConstructor(NetworkInterceptorPlugin.class);
                Interceptor interceptor = (Interceptor)constructor.newInstance(this.plugin);
                this.interceptors.put(interceptMethod, interceptor);
            }
            catch (Throwable t) {
                this.plugin.getLogger().log(Level.SEVERE, "Exception occurred whilst initialising method " + (Object)((Object)interceptMethod), t);
            }
        }
    }

    private void setupLoggers(AbstractConfiguration configuration) {
        if (!configuration.getBoolean("logging.enabled", true)) {
            this.plugin.getLogger().info("Logging is not enabled");
            return;
        }
        this.ignoreAllowed = configuration.getBoolean("logging.ignore-allowed", false);
        String mode = configuration.getString("logging.mode", null);
        if (mode == null) {
            this.plugin.getLogger().severe("Unknown logging mode: " + mode);
            throw new IllegalConfigStateException("logging.mode", mode, "all", "console", "file");
        }
        boolean truncateFile = configuration.getBoolean("logging.truncate-file-on-start", true) && this.isOnStartup;
        boolean includeTraces = configuration.getBoolean("logging.include-traces", true);
        switch (mode.toLowerCase()) {
            case "all": {
                this.plugin.getLogger().info("Using console+file combined logger");
                this.logger = new CompositeLogger(new ConsoleLogger(this.plugin, includeTraces), new FileLogger(this.plugin, truncateFile));
                break;
            }
            case "console": {
                this.plugin.getLogger().info("Using console logger");
                this.logger = new ConsoleLogger(this.plugin, includeTraces);
                break;
            }
            case "file": {
                this.plugin.getLogger().info("Using file logger");
                this.logger = new FileLogger(this.plugin, truncateFile);
                break;
            }
            default: {
                this.plugin.getLogger().severe("Unknown logging mode: " + mode);
                throw new IllegalConfigStateException("logging.mode", mode, "all", "console", "file");
            }
        }
    }

    private void setupBlockers(AbstractConfiguration configuration) {
        if (!configuration.getBoolean("blocking.enabled", false)) {
            this.plugin.getLogger().info("Blocking is not enabled");
            return;
        }
        ImmutableList list = ImmutableList.copyOf(configuration.getStringList("targets"));
        this.options = this.generatePluginOptions(configuration);
        PluginAwareBlocker<PLUGIN> pluginBlocker = new PluginAwareBlocker<PLUGIN>(this.options);
        String mode = configuration.getString("mode", null);
        if (mode == null) {
            this.plugin.getLogger().severe("Unknown mode: " + mode);
            throw new IllegalConfigStateException("mode", mode, "allow", "deny");
        }
        switch (mode.toLowerCase()) {
            case "allow": {
                this.plugin.getLogger().info("Using blocking strategy allow");
                this.blocker = new AllowBlocker((List<String>)list);
                break;
            }
            case "deny": {
                this.plugin.getLogger().info("Using blocking strategy deny");
                this.blocker = new BlockBlocker((List<String>)list);
                break;
            }
            default: {
                this.plugin.getLogger().severe("Unknown mode: " + mode);
                throw new IllegalConfigStateException("mode", mode, "allow", "deny");
            }
        }
        if (this.blocker != null) {
            ManualPluginOptions manOptions = new ManualPluginOptions(null);
            ManualPluginDetectingBlocker<PLUGIN> manBlocker = manOptions.isEmpty() ? null : new ManualPluginDetectingBlocker<PLUGIN>(this.options, manOptions, this.plugin.getPlatformType());
            this.blocker = new CompositeBlocker<PLUGIN>(manBlocker, pluginBlocker, this.blocker);
        }
        if (this.blocker != null && configuration.getBoolean("mapping.enabled", true)) {
            long similarStackTimeoutMs = configuration.getLong("mapping.timer", -1L);
            if (similarStackTimeoutMs < 0L) {
                this.plugin.getLogger().severe("Mapping timer incorrect or not specified");
                throw new IllegalConfigStateException("mapping.timer", configuration.get("mapping.timer", null), "(Need a positive number)");
            }
            this.plugin.getLogger().info("Using a mapping blocker with timer of " + similarStackTimeoutMs + "ms");
            this.blocker = new LearningBlocker<PLUGIN>(this.blocker, similarStackTimeoutMs);
        }
    }

    private TrustedAndBlockedOptions<PLUGIN> generatePluginOptions(AbstractConfiguration configuration) {
        KeepPlugins keepType;
        String keepTypeName = configuration.getString("keep-type", "ALL");
        try {
            keepType = KeepPlugins.valueOf(keepTypeName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Unknown keep type: " + keepTypeName + ". Defaulting to ALL");
            keepType = KeepPlugins.ALL;
        }
        boolean allowNonPlugin = configuration.getBoolean("keep-non-plugins", false);
        HashSet<String> trustedPlugins = new HashSet<String>(configuration.getStringList("trusted-plugins"));
        PluginOptions<PLUGIN> trustedOpts = this.getPluginOptions(trustedPlugins, keepType, allowNonPlugin, true);
        HashSet<String> blockedPlugins = new HashSet<String>(configuration.getStringList("blocked-plugins"));
        PluginOptions<PLUGIN> blockedOpts = this.getPluginOptions(blockedPlugins, keepType, allowNonPlugin, false);
        for (String trustedPluginName : trustedPlugins) {
            if (!blockedPlugins.contains(trustedPluginName)) continue;
            this.plugin.getLogger().warning("Conflicting trusted-plugins and blocked-plugins specifications were detected. Outbound connections by " + trustedPluginName + " will be blocked.");
        }
        return new TrustedAndBlockedOptions<PLUGIN>(trustedOpts, blockedOpts);
    }

    private PluginOptions<PLUGIN> getPluginOptions(Set<String> plugins, KeepPlugins keepType, boolean allowNonPlugin, boolean trust) {
        if (this.plugin.getPlatformType() == Platform.BUKKIT) {
            return new BukkitPluginOptions((JavaPlugin)this.plugin, keepType, allowNonPlugin, plugins, trust);
        }
        if (this.plugin.getPlatformType() == Platform.BUNGEE) {
            return new BungeePluginOptions((Plugin)this.plugin, keepType, allowNonPlugin, plugins, trust);
        }
        if (this.plugin.getPlatformType() == Platform.VELOCITY) {
            return new VelocityPluginOptions((VelocityNetworkInterceptor)this.plugin, keepType, allowNonPlugin, plugins, trust);
        }
        throw new IllegalStateException("Unknown type of plugin: " + this.plugin);
    }

    public TrustedAndBlockedOptions<PLUGIN> getPluginOptions() {
        return this.options;
    }

    public Blocker<PLUGIN> getBlocker() {
        return this.blocker;
    }

    public EventLogger<PLUGIN> getEventLogger() {
        return this.logger;
    }

    public Map<InterceptMethod, Interceptor> getInterceptors() {
        return new EnumMap<InterceptMethod, Interceptor>(this.interceptors);
    }

    public static enum InterceptMethod {
        SECURITY_MANAGER("security-manager", SecurityManagerInterceptor.class),
        PROXY_SELECTOR("proxy-selector", ProxySelectorInterceptor.class);

        private final String name;
        private final Class<? extends Interceptor> clazz;

        private InterceptMethod(String name, Class<? extends Interceptor> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public static InterceptMethod fromString(String string) {
            for (InterceptMethod method : InterceptMethod.values()) {
                if (!method.name.equalsIgnoreCase(string)) continue;
                return method;
            }
            throw new IllegalArgumentException();
        }
    }

    public static class IllegalConfigStateException
    extends IllegalStateException {
        public IllegalConfigStateException(String path, Object value, Object ... options) {
            super(IllegalConfigStateException.getMessage(path, value, options));
        }

        private static final String getMessage(String path, Object value, Object[] options) {
            return "Illegal config value for '" + path + "': " + value + (options.length == 0 ? "" : (options.length == 1 ? " " + options[0] : " (Available: " + Arrays.asList(options) + ")"));
        }
    }
}

