/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.common;

import com.velocitypowered.api.command.CommandSource;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;

public interface CommonCommandSender {
    public void send(String var1);

    public void send(String ... var1);

    public boolean hasPermission(String var1);

    public static class Velocity
    implements CommonCommandSender {
        private final CommandSource source;

        public Velocity(CommandSource source) {
            this.source = source;
        }

        @Override
        public void send(String msg) {
            this.source.sendMessage((Component)Component.text(msg));
        }

        @Override
        public void send(String ... msgs) {
            for (String msg : msgs) {
                this.send(msg);
            }
        }

        @Override
        public boolean hasPermission(String perm) {
            return this.source.hasPermission(perm);
        }
    }

    public static class Bungee
    implements CommonCommandSender {
        private final CommandSender sender;

        public Bungee(CommandSender sender) {
            this.sender = sender;
        }

        @Override
        public void send(String msg) {
            this.sender.sendMessage((BaseComponent)new TextComponent(msg));
        }

        @Override
        public void send(String ... msgs) {
            for (String msg : msgs) {
                this.send(msg);
            }
        }

        @Override
        public boolean hasPermission(String perm) {
            return this.sender.hasPermission(perm);
        }
    }

    public static final class Spigot
    implements CommonCommandSender {
        private final org.bukkit.command.CommandSender sender;

        public Spigot(org.bukkit.command.CommandSender sender) {
            this.sender = sender;
        }

        @Override
        public void send(String msg) {
            this.sender.sendMessage(msg);
        }

        @Override
        public void send(String ... msgs) {
            this.sender.sendMessage(msgs);
        }

        @Override
        public boolean hasPermission(String perm) {
            return this.sender.hasPermission(perm);
        }
    }
}

