/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.bungee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import me.lucko.networkinterceptor.NetworkInterceptorCommand;
import me.lucko.networkinterceptor.bstats.bungeecord.Metrics;
import me.lucko.networkinterceptor.bstats.charts.SimplePie;
import me.lucko.networkinterceptor.bungee.BungeeConfiguration;
import me.lucko.networkinterceptor.bungee.BungeePluginManager;
import me.lucko.networkinterceptor.common.AbstractConfiguration;
import me.lucko.networkinterceptor.common.CommonNetworkInterceptor;
import me.lucko.networkinterceptor.common.NetworkInterceptorPlugin;
import me.lucko.networkinterceptor.common.Platform;
import me.lucko.networkinterceptor.common.PluginManager;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class BungeeNetworkInterceptor
extends Plugin
implements NetworkInterceptorPlugin<Plugin> {
    private static final String SAMPLE_ALLOW_CONFIG_FILE_NAME = "sample-allow-config.yml";
    private static final String SAMPLE_DENY_CONFIG_FILE_NAME = "sample-deny-config.yml";
    private final CommonNetworkInterceptor<BungeeNetworkInterceptor, Plugin> delegate;
    private Configuration configuration;
    private BungeeConfiguration bungeeConfig;
    private BungeePluginManager pluginManager;

    public BungeeNetworkInterceptor() {
        this.saveDefaultConfig();
        this.saveResource(SAMPLE_ALLOW_CONFIG_FILE_NAME);
        this.saveResource(SAMPLE_DENY_CONFIG_FILE_NAME);
        this.loadConfig();
        this.delegate = new CommonNetworkInterceptor(this);
        boolean useMetrics = this.getConfiguration().getBoolean("enable-metrics", true);
        if (useMetrics) {
            int pluginId = 12035;
            Metrics metrics = new Metrics(this, pluginId);
            metrics.addCustomChart(new SimplePie("mode", () -> this.configuration.getString("mode", "N/A")));
        }
        this.getLogger().info(useMetrics ? "bStats metrics enabled" : "bStats metrics disabled");
        this.pluginManager = new BungeePluginManager(this.getProxy().getPluginManager());
    }

    private void loadConfig() {
        try {
            this.configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            this.getLogger().warning("Problem loading config");
            e.printStackTrace();
        }
        this.bungeeConfig = new BungeeConfiguration(this.configuration, "");
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new NetworkInterceptorCommand<Plugin>(this).asBungeeCommand());
    }

    @Override
    public void onEnable() {
        this.delegate.onEnable();
    }

    @Override
    public void onDisable() {
        this.delegate.onDisable();
    }

    @Override
    public void saveDefaultConfig() {
        this.saveResource("config.yml");
    }

    public void saveResource(String fileName) {
        File file;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(file = new File(this.getDataFolder(), fileName)).exists()) {
            try (InputStream in = this.getResourceAsStream(fileName);){
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveConfig() {
        if (this.configuration == null) {
            this.loadConfig();
        }
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.configuration, new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            this.getLogger().warning("Problem saving default config");
            e.printStackTrace();
        }
    }

    @Override
    public AbstractConfiguration getConfiguration() {
        return this.bungeeConfig;
    }

    @Override
    public void reloadConfig() {
        this.loadConfig();
    }

    @Override
    public void disablePlugin() {
        this.getLogger().severe("Plugin should now disable but I am unaware as to how this should be done");
    }

    @Override
    public String getServerVersion() {
        return this.getProxy().getVersion();
    }

    @Override
    public String getPluginVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    public void runTaskLater(Runnable runnable, long ticks) {
        this.getProxy().getScheduler().schedule((Plugin)this, runnable, ticks * 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Platform getPlatformType() {
        return Platform.BUNGEE;
    }

    @Override
    public CommonNetworkInterceptor<BungeeNetworkInterceptor, Plugin> getDelegate() {
        return this.delegate;
    }

    @Override
    public Plugin asPlugin() {
        return this;
    }

    @Override
    public void reload() {
        this.reloadConfig();
        this.delegate.disable();
        try {
            this.delegate.enable();
        }
        catch (CommonNetworkInterceptor.IllegalConfigStateException e) {
            this.getLogger().severe(e.getMessage());
            this.getLogger().severe("Disabling plugin");
            this.disablePlugin();
        }
    }

    @Override
    public PluginManager<Plugin> getNIPluginManager() {
        return this.pluginManager;
    }
}

