/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.blockers;

import java.util.Map;
import me.lucko.networkinterceptor.InterceptEvent;
import me.lucko.networkinterceptor.blockers.Blocker;
import me.lucko.networkinterceptor.common.Platform;
import me.lucko.networkinterceptor.plugin.ManualPluginOptions;
import me.lucko.networkinterceptor.plugin.TrustedAndBlockedOptions;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ManualPluginDetectingBlocker<PLUGIN>
implements Blocker<PLUGIN> {
    private final TrustedAndBlockedOptions<PLUGIN> pluginOptions;
    private final ManualPluginOptions manualPluginOptions;
    private final Platform platform;

    public ManualPluginDetectingBlocker(TrustedAndBlockedOptions<PLUGIN> pluginOptions, ManualPluginOptions manualPluginOptions, Platform platform) {
        this.pluginOptions = pluginOptions;
        this.manualPluginOptions = manualPluginOptions;
        this.platform = platform;
    }

    @Override
    public boolean shouldBlock(InterceptEvent<PLUGIN> event) {
        Plugin plugin;
        boolean shouldBlock;
        String pluginName = this.findFirstPluginName(event);
        if (pluginName == null) {
            return true;
        }
        boolean bl = shouldBlock = !this.pluginOptions.getTrustedOptions().isListedAsTrustedPluginName(pluginName);
        if (!shouldBlock && this.platform == Platform.BUKKIT && (plugin = Bukkit.getPluginManager().getPlugin(pluginName)) != null) {
            event.setTrustedPlugin(plugin);
        }
        return shouldBlock;
    }

    private String findFirstPluginName(InterceptEvent<PLUGIN> event) {
        for (Map.Entry<StackTraceElement, PLUGIN> entry : event.getNonInternalStackTraceWithPlugins().entrySet()) {
            StackTraceElement trace;
            String pluginName;
            if (entry.getValue() != null || (pluginName = this.manualPluginOptions.getPluginNameFor((trace = entry.getKey()).getClassName())) == null) continue;
            if (this.platform == Platform.BUKKIT) {
                Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
                if (plugin != null) {
                    event.updateTraceElement(trace, plugin);
                }
            } else if (this.platform == Platform.BUNGEE) {
                // empty if block
            }
            return pluginName;
        }
        return null;
    }
}

