/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.blockers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import me.lucko.networkinterceptor.InterceptEvent;
import me.lucko.networkinterceptor.blockers.Blocker;

public class LearningBlocker<PLUGIN>
implements Blocker<PLUGIN> {
    private final Blocker<PLUGIN> delegate;
    private final Cache<StackTraces, StackTraces> cachedAllowedTraces;
    private final Cache<StackTraces, StackTraces> cachedBlockedTraces;
    private final long similarStackTimeoutMs;

    public LearningBlocker(Blocker<PLUGIN> delegate, long similarStackTimeoutMs) {
        this.delegate = delegate;
        this.similarStackTimeoutMs = similarStackTimeoutMs;
        this.cachedAllowedTraces = CacheBuilder.newBuilder().expireAfterWrite(similarStackTimeoutMs, TimeUnit.MILLISECONDS).build();
        this.cachedBlockedTraces = CacheBuilder.newBuilder().expireAfterWrite(similarStackTimeoutMs, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public boolean shouldBlock(InterceptEvent<PLUGIN> event) {
        boolean rawBlock = this.delegate.shouldBlock(event);
        StackTraces traces = new StackTraces(event.getNonInternalStackTraceWithPlugins(), event.getHost());
        StackTraces prev = (StackTraces)this.cachedAllowedTraces.getIfPresent((Object)traces);
        if (prev != null) {
            event.setOriginalHost(prev.originalHost);
        }
        if (!rawBlock) {
            if (prev == null) {
                this.cachedAllowedTraces.put((Object)traces, (Object)traces);
            } else {
                this.cachedAllowedTraces.put((Object)prev, (Object)prev);
            }
            return false;
        }
        if (prev != null) {
            return false;
        }
        prev = (StackTraces)this.cachedBlockedTraces.getIfPresent((Object)traces);
        if (prev != null) {
            event.setOriginalHost(prev.originalHost);
        } else {
            this.cachedBlockedTraces.put((Object)traces, (Object)traces);
        }
        return true;
    }

    public void clear() {
        this.cachedAllowedTraces.invalidateAll();
        this.cachedBlockedTraces.invalidateAll();
    }

    public Blocker<PLUGIN> getDelegate() {
        return this.delegate;
    }

    public long getTimeoutMs() {
        return this.similarStackTimeoutMs;
    }

    private class StackTraces {
        private final Map<StackTraceElement, PLUGIN> payload;
        private final String originalHost;

        private StackTraces(Map<StackTraceElement, PLUGIN> payload, String originalHost) {
            this.payload = payload;
            this.originalHost = originalHost;
        }

        public int hashCode() {
            return Objects.hash(this.payload);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StackTraces)) {
                return false;
            }
            StackTraces o = (StackTraces)other;
            return this.payload.equals(o.payload);
        }
    }
}

