/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor.blockers;

import java.util.Arrays;
import me.lucko.networkinterceptor.InterceptEvent;
import me.lucko.networkinterceptor.blockers.Blocker;
import me.lucko.networkinterceptor.blockers.ManualPluginDetectingBlocker;
import me.lucko.networkinterceptor.blockers.PluginAwareBlocker;

public class CompositeBlocker<PLUGIN>
implements Blocker<PLUGIN> {
    private final ManualPluginDetectingBlocker<PLUGIN> manual;
    private final Blocker<PLUGIN>[] delegates;
    private boolean useManualBlocker = true;
    private final PluginAwareBlocker<PLUGIN> pluginAwareBlocker;

    @SafeVarargs
    public CompositeBlocker(ManualPluginDetectingBlocker<PLUGIN> manualBlocker, PluginAwareBlocker<PLUGIN> pluginAwareBlocker, Blocker<PLUGIN> ... delegates) {
        this.manual = manualBlocker;
        if (this.manual == null) {
            this.useManualBlocker = false;
        }
        this.pluginAwareBlocker = pluginAwareBlocker;
        this.delegates = delegates;
    }

    @Override
    public boolean shouldBlock(InterceptEvent<PLUGIN> event) {
        if (this.useManualBlocker && !this.manual.shouldBlock(event)) {
            return false;
        }
        if (this.pluginAwareBlocker.hasTrustedPlugins(event)) {
            return false;
        }
        if (this.pluginAwareBlocker.hasBlockedPlugins(event)) {
            return true;
        }
        for (Blocker<PLUGIN> delegate : this.delegates) {
            boolean shouldBlock;
            if (delegate == this.pluginAwareBlocker) continue;
            try {
                shouldBlock = delegate.shouldBlock(event);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (shouldBlock) continue;
            return false;
        }
        return true;
    }

    public Blocker<PLUGIN>[] getDelegates() {
        return Arrays.copyOf(this.delegates, this.delegates.length);
    }

    public void stopUsingManualBlocker() {
        this.useManualBlocker = false;
    }
}

