/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor;

import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.plugin.PluginContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.lucko.networkinterceptor.blockers.AllowBlocker;
import me.lucko.networkinterceptor.blockers.Blocker;
import me.lucko.networkinterceptor.blockers.CompositeBlocker;
import me.lucko.networkinterceptor.blockers.LearningBlocker;
import me.lucko.networkinterceptor.blockers.PluginAwareBlocker;
import me.lucko.networkinterceptor.common.CommonCommandSender;
import me.lucko.networkinterceptor.common.CommonNetworkInterceptor;
import me.lucko.networkinterceptor.common.NetworkInterceptorPlugin;
import me.lucko.networkinterceptor.common.Platform;
import me.lucko.networkinterceptor.core.api.SlimeDogPlugin;
import me.lucko.networkinterceptor.core.impl.commands.BukkitFacingParentCommand;
import me.lucko.networkinterceptor.interceptors.Interceptor;
import me.lucko.networkinterceptor.loggers.CompositeLogger;
import me.lucko.networkinterceptor.loggers.ConsoleLogger;
import me.lucko.networkinterceptor.loggers.EventLogger;
import me.lucko.networkinterceptor.loggers.FileLogger;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.TabExecutor;
import org.bukkit.command.Command;
import org.bukkit.util.StringUtil;

public class NetworkInterceptorCommand<PLUGIN> {
    private static final List<String> OPTIONS = Arrays.asList("reload", "info");
    private final NetworkInterceptorPlugin<PLUGIN> plugin;

    public NetworkInterceptorCommand(NetworkInterceptorPlugin<PLUGIN> plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommonCommandSender sender, String[] args) {
        if (args.length == 0) {
            String versionMsg = "Running NetworkInterceptor v" + this.plugin.getPluginVersion();
            if (this.plugin.getPlatformType() == Platform.BUKKIT || this.plugin.getPlatformType() == Platform.BUNGEE) {
                versionMsg = ChatColor.RED + versionMsg;
            }
            sender.send(versionMsg);
            String helpMsg = "Use '/networkinterceptor reload' to reload the configuration.";
            if (this.plugin.getPlatformType() == Platform.BUKKIT || this.plugin.getPlatformType() == Platform.BUNGEE) {
                helpMsg = ChatColor.GRAY + helpMsg;
            }
            sender.send(helpMsg);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload") && sender.hasPermission("networkinterceptor.command.reload")) {
            this.plugin.reload();
            String msg = "NetworkInterceptor configuration reloaded.";
            if (this.plugin.getPlatformType() == Platform.BUKKIT || this.plugin.getPlatformType() == Platform.BUNGEE) {
                msg = ChatColor.GRAY + msg;
            }
            sender.send(msg);
            return true;
        }
        if (args[0].equalsIgnoreCase("info") && sender.hasPermission("networkinterceptor.command.info")) {
            this.sendInfoMessage(sender);
            return true;
        }
        String msg = "Unknown subcommand.";
        if (this.plugin.getPlatformType() == Platform.BUKKIT || this.plugin.getPlatformType() == Platform.BUNGEE) {
            msg = ChatColor.RED + msg;
        }
        sender.send(msg);
        return true;
    }

    private void sendInfoMessage(CommonCommandSender sender) {
        boolean useMetrics = this.plugin.getConfiguration().getBoolean("enable-metrics", true);
        sender.send(useMetrics ? "bStats metrics enabled" : "bStats metrics disabled");
        sender.send(this.getBlockerMessage().split("\n"));
        sender.send(this.getLoggerMessage());
        sender.send(this.getInterceptorsMessage());
    }

    public String getInterceptorsMessage() {
        List<String> methods = this.plugin.getConfiguration().getStringList("methods");
        if (methods.isEmpty()) {
            return "No methods are defined";
        }
        for (String method : new ArrayList<String>(methods)) {
            try {
                CommonNetworkInterceptor.InterceptMethod.fromString(method);
            }
            catch (IllegalArgumentException e) {
                methods.remove(method);
            }
        }
        Map<CommonNetworkInterceptor.InterceptMethod, Interceptor> interceptors = this.plugin.getDelegate().getInterceptors();
        if (methods.size() != interceptors.size()) {
            return "Real interceptors: " + interceptors + "\nConfig defined: " + methods;
        }
        return "Interceptors: " + methods;
    }

    private String getLoggerMessage() {
        if (!this.plugin.getConfiguration().getBoolean("logging.enabled", true)) {
            return "Logging is not enabled";
        }
        EventLogger<PLUGIN> logger = this.plugin.getDelegate().getEventLogger();
        if (logger == null) {
            String mode = this.plugin.getConfiguration().getString("logging.mode", "console");
            return "Unknown logging mode: " + mode;
        }
        if (logger instanceof CompositeLogger) {
            return "Using console+file combined logger";
        }
        if (logger instanceof ConsoleLogger) {
            return "Using console logger";
        }
        if (logger instanceof FileLogger) {
            return "Using file logger";
        }
        return "Unknown logger: " + logger;
    }

    private String getBlockerMessage() {
        String blockerMessage;
        Blocker<PLUGIN> blocker = this.plugin.getDelegate().getBlocker();
        if (blocker == null) {
            String mode = this.plugin.getConfiguration().getString("mode", "deny");
            blockerMessage = !mode.equalsIgnoreCase("allow") && !mode.equalsIgnoreCase("deny") ? "Unknown mode: " + mode : "Blocking is not enabled";
        } else if (blocker instanceof LearningBlocker) {
            Blocker delegate = ((LearningBlocker)blocker).getDelegate();
            blockerMessage = this.getCompositeBlockerMessage(delegate) + "\nUsing a mapping blocker with timer of " + ((LearningBlocker)blocker).getTimeoutMs() + "ms";
        } else {
            blockerMessage = this.getCompositeBlockerMessage(blocker);
        }
        return blockerMessage;
    }

    private String getCompositeBlockerMessage(Blocker<PLUGIN> blocker) {
        String blockerMessage;
        if (!(blocker instanceof CompositeBlocker)) {
            blockerMessage = "Unknown type of delegate: " + blocker;
        } else {
            CompositeBlocker compositeBlocker = (CompositeBlocker)blocker;
            Blocker<PLUGIN>[] delegates = compositeBlocker.getDelegates();
            if (delegates.length != 2) {
                blockerMessage = "Unknown delegates: " + Arrays.asList(delegates);
            } else {
                Blocker mainBlocker = delegates[0];
                Blocker pluginBlocker = delegates[1];
                blockerMessage = !(pluginBlocker instanceof PluginAwareBlocker) ? "Miscondigured delegates: " + Arrays.asList(delegates) : this.getMainBlockerMessage(mainBlocker);
            }
        }
        return blockerMessage;
    }

    private String getMainBlockerMessage(Blocker<PLUGIN> mainBlocker) {
        if (mainBlocker instanceof AllowBlocker) {
            return "Using blocking strategy allow";
        }
        return "Using blocking strategy deny";
    }

    public SpigotWrapper asSpigotCommand() {
        return new SpigotWrapper(this);
    }

    public BungeeWrapper asBungeeCommand() {
        return new BungeeWrapper(this);
    }

    public VelocityWrapper asVelocityCommand() {
        return new VelocityWrapper(this);
    }

    public static class SpigotWrapper
    extends BukkitFacingParentCommand {
        private final NetworkInterceptorCommand<SlimeDogPlugin> cmd;

        public SpigotWrapper(NetworkInterceptorCommand<SlimeDogPlugin> md) {
            this.cmd = md;
        }

        @Override
        public List<String> onTabComplete(org.bukkit.command.CommandSender sender, Command command, String alias, String[] args) {
            if (args.length == 1) {
                return (List)StringUtil.copyPartialMatches((String)args[0], (Iterable)OPTIONS, new ArrayList());
            }
            return Collections.emptyList();
        }

        @Override
        public boolean onCommand(org.bukkit.command.CommandSender sender, Command command, String label, String[] args) {
            return this.cmd.onCommand(new CommonCommandSender.Spigot(sender), args);
        }
    }

    public static class BungeeWrapper
    extends net.md_5.bungee.api.plugin.Command
    implements TabExecutor {
        private static final String NAME = "networkinterceptorbungee";
        private static final String PERMISSION = "networkinterceptor.command";
        private static final String ALIASES = "nib";
        private static final List<String> OPTIONS = Collections.unmodifiableList(Arrays.asList("reload", "info"));
        private final NetworkInterceptorCommand<Plugin> cmd;

        public BungeeWrapper(NetworkInterceptorCommand<Plugin> cmd) {
            super(NAME, PERMISSION, new String[]{ALIASES});
            this.cmd = cmd;
        }

        public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
            if (args.length == 1) {
                return OPTIONS;
            }
            return Collections.emptyList();
        }

        public void execute(CommandSender sender, String[] args) {
            this.cmd.onCommand(new CommonCommandSender.Bungee(sender), args);
        }
    }

    public static class VelocityWrapper
    implements SimpleCommand {
        private final NetworkInterceptorCommand<PluginContainer> cmd;

        private VelocityWrapper(NetworkInterceptorCommand<PluginContainer> cmd) {
            this.cmd = cmd;
        }

        public void execute(SimpleCommand.Invocation invocation) {
            this.cmd.onCommand(new CommonCommandSender.Velocity(invocation.source()), (String[])invocation.arguments());
        }
    }
}

