/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor;

import java.io.File;
import java.util.function.BiConsumer;
import me.lucko.networkinterceptor.BukkitPluginManager;
import me.lucko.networkinterceptor.NetworkInterceptorCommand;
import me.lucko.networkinterceptor.blockers.Blocker;
import me.lucko.networkinterceptor.blockers.CompositeBlocker;
import me.lucko.networkinterceptor.blockers.LearningBlocker;
import me.lucko.networkinterceptor.bstats.bukkit.Metrics;
import me.lucko.networkinterceptor.bstats.charts.SimplePie;
import me.lucko.networkinterceptor.bukkit.BukkitConfiguration;
import me.lucko.networkinterceptor.common.AbstractConfiguration;
import me.lucko.networkinterceptor.common.CommonNetworkInterceptor;
import me.lucko.networkinterceptor.common.NetworkInterceptorPlugin;
import me.lucko.networkinterceptor.common.Platform;
import me.lucko.networkinterceptor.common.PluginManager;
import me.lucko.networkinterceptor.core.impl.SlimeDogCore;
import me.lucko.networkinterceptor.core.impl.utils.UpdateChecker;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NetworkInterceptor
extends SlimeDogCore
implements NetworkInterceptorPlugin<JavaPlugin> {
    private static final int SPIGOT_ID = 53351;
    private static final String HANGAR_AUTHOR = "SlimeDog";
    private static final String HANGAR_SLUG = "NetworkInterceptor";
    private static final String SAMPLE_ALLOW_CONFIG_FILE_NAME = "sample-allow-config.yml";
    private static final String SAMPLE_DENY_CONFIG_FILE_NAME = "sample-deny-config.yml";
    private final CommonNetworkInterceptor<NetworkInterceptor, JavaPlugin> delegate;
    private BukkitConfiguration config;
    private boolean registerManualStopTask = false;
    private PluginManager<JavaPlugin> pluginManager;

    public NetworkInterceptor() {
        this.saveDefaultConfig();
        this.saveResourceInternal(SAMPLE_ALLOW_CONFIG_FILE_NAME);
        this.saveResourceInternal(SAMPLE_DENY_CONFIG_FILE_NAME);
        this.config = new BukkitConfiguration(this.getDefaultConfig());
        this.delegate = new CommonNetworkInterceptor(this);
        boolean useMetrics = this.getConfig().getBoolean("enable-metrics", true);
        if (useMetrics) {
            int pluginId = 11822;
            Metrics metrics = new Metrics(this, pluginId);
            metrics.addCustomChart(new SimplePie("mode", () -> this.config.getString("mode", "N/A")));
            metrics.addCustomChart(new SimplePie("trustedplugins", () -> String.valueOf(this.delegate.getPluginOptions().getTrustedOptions().getPluginNames().size())));
            metrics.addCustomChart(new SimplePie("blockedplugins", () -> String.valueOf(this.delegate.getPluginOptions().getBlockedOptions().getPluginNames().size())));
        }
        this.getLogger().info(useMetrics ? "bStats metrics enabled" : "bStats metrics disabled");
        this.pluginManager = new BukkitPluginManager(this.getServer().getPluginManager());
    }

    private void saveResourceInternal(String name) {
        File file = new File(this.getDataFolder(), name);
        if (file.exists()) {
            return;
        }
        this.saveResource(name, false);
    }

    @Override
    public void pluginEnabled() {
        this.delegate.onEnable();
        if (this.registerManualStopTask) {
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                Blocker delegate;
                if (this.delegate.getBlocker() instanceof CompositeBlocker) {
                    ((CompositeBlocker)this.delegate.getBlocker()).stopUsingManualBlocker();
                } else if (this.delegate.getBlocker() instanceof LearningBlocker && (delegate = ((LearningBlocker)this.delegate.getBlocker()).getDelegate()) instanceof CompositeBlocker) {
                    ((CompositeBlocker)delegate).stopUsingManualBlocker();
                }
            }, 1L);
        }
        this.getCommand("networkinterceptor").setExecutor((CommandExecutor)new NetworkInterceptorCommand<JavaPlugin>(this).asSpigotCommand());
        if (this.getDefaultConfig().getConfig().getBoolean("check-for-updates", true)) {
            String source = this.getDefaultConfig().getConfig().getString("update-source", "Hangar");
            BiConsumer<UpdateChecker.VersionResponse, String> consumer = (response, version) -> {
                switch (response) {
                    case LATEST: {
                        this.getLogger().info("Already on latest version");
                        break;
                    }
                    case FOUND_NEW: {
                        this.getLogger().info("Found new version: " + version);
                        break;
                    }
                    case UNAVAILABLE: {
                        this.getLogger().info("Version information not available");
                    }
                }
            };
            UpdateChecker checker = source.equalsIgnoreCase("Hangar") ? UpdateChecker.forHangar(this, consumer, HANGAR_AUTHOR, HANGAR_SLUG) : UpdateChecker.forSpigot(this, consumer, 53351);
            checker.check();
        }
    }

    @Override
    public void pluginDisabled() {
        this.disable();
    }

    @Override
    public void reload() {
        this.reloadConfig();
        this.config = new BukkitConfiguration(this.getDefaultConfig());
        this.disable();
        try {
            this.enable();
        }
        catch (CommonNetworkInterceptor.IllegalConfigStateException e) {
            this.getLogger().severe(e.getMessage());
            this.getLogger().severe("Disabling plugin");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void enable() throws CommonNetworkInterceptor.IllegalConfigStateException {
        this.delegate.enable();
    }

    private void disable() {
        this.delegate.disable();
    }

    @Override
    public AbstractConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void disablePlugin() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    @Override
    public String getServerVersion() {
        return this.getServer().getVersion();
    }

    @Override
    public String getPluginVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    public void runTaskLater(Runnable runnable, long ticks) {
        this.getServer().getScheduler().runTaskLater((Plugin)this, runnable, ticks);
    }

    @Override
    public Platform getPlatformType() {
        return Platform.BUKKIT;
    }

    @Override
    public CommonNetworkInterceptor<NetworkInterceptor, JavaPlugin> getDelegate() {
        return this.delegate;
    }

    @Override
    public JavaPlugin asPlugin() {
        return this;
    }

    @Override
    public PluginManager<JavaPlugin> getNIPluginManager() {
        return this.pluginManager;
    }
}

