/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.networkinterceptor;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import me.lucko.networkinterceptor.common.Platform;
import org.bukkit.plugin.java.JavaPlugin;

public class InterceptEvent<PLUGIN> {
    private static final int MAX_INTERNAL_TRACES = 2;
    private final String host;
    private final StackTraceElement[] stackTrace;
    private final Map<StackTraceElement, PLUGIN> nonInternalStackTrace = new LinkedHashMap<StackTraceElement, PLUGIN>();
    private final Set<PLUGIN> tracedPlugins = new LinkedHashSet<PLUGIN>();
    private final Platform platform;
    private final PluginFinder<PLUGIN> pluginFinder;
    private String originalHost;
    private boolean isRepeat = false;
    private PLUGIN trustedPlugin;
    private PLUGIN blockedPlugin;

    public InterceptEvent(String host, StackTraceElement[] stackTrace, Platform platform) {
        this(host, stackTrace, platform, null);
    }

    public InterceptEvent(String host, StackTraceElement[] stackTrace, Platform platform, PluginFinder<PLUGIN> finder) {
        this.host = host;
        this.stackTrace = stackTrace;
        this.platform = platform;
        this.pluginFinder = platform == Platform.BUKKIT ? new BukkitPluginFinder() : (platform == Platform.BUNGEE ? new BungeePluginFinder() : (platform == Platform.VELOCITY ? new DummyPluginFinder() : finder));
        this.generateNonInternalStackTrace();
    }

    public String getHost() {
        return this.host;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public void updateTraceElement(StackTraceElement trace, PLUGIN plugin) {
        if (!this.nonInternalStackTrace.containsKey(trace)) {
            throw new IllegalArgumentException("Stack trace not within event non-internal trace: " + trace);
        }
        PLUGIN prev = this.nonInternalStackTrace.get(trace);
        if (prev != null) {
            throw new IllegalStateException("Stack trace " + trace + " already mapped to " + prev);
        }
        if (plugin == null) {
            throw new IllegalArgumentException("Cannot update trace to null plugin");
        }
        this.nonInternalStackTrace.put(trace, plugin);
    }

    public Map<StackTraceElement, PLUGIN> getNonInternalStackTraceWithPlugins() {
        return Collections.unmodifiableMap(this.nonInternalStackTrace);
    }

    public Set<PLUGIN> getOrderedTracedPlugins() {
        return new LinkedHashSet<PLUGIN>(this.tracedPlugins);
    }

    private void generateNonInternalStackTrace() {
        boolean shouldPrint = false;
        int internalTraces = 0;
        for (StackTraceElement element : this.stackTrace) {
            if (!shouldPrint) {
                boolean isInternal;
                boolean internalToPlugin = element.getClassName().startsWith("me.lucko.networkinterceptor");
                boolean bl = isInternal = internalToPlugin || element.getClassName().startsWith("java.net") || element.getClassName().startsWith("java.security") || element.getClassName().startsWith("sun.net") || element.getClassName().startsWith("sun.security.ssl");
                if (!isInternal) {
                    shouldPrint = true;
                } else if (internalToPlugin && internalTraces++ >= 2) {
                    shouldPrint = true;
                }
            }
            if (!shouldPrint) continue;
            PLUGIN providingPlugin = this.getProvidingPlugin(element);
            if (providingPlugin != null) {
                this.tracedPlugins.add(providingPlugin);
            }
            this.nonInternalStackTrace.put(element, providingPlugin);
        }
    }

    private PLUGIN getProvidingPlugin(StackTraceElement element) {
        if (this.pluginFinder != null) {
            return this.pluginFinder.findPlugin(element);
        }
        throw new IllegalStateException("Plugin finder not defined! Platform: " + (Object)((Object)this.platform));
    }

    public void setOriginalHost(String host) {
        this.isRepeat = true;
        if (host != null && host.equals(this.host)) {
            return;
        }
        this.originalHost = host;
    }

    public boolean isRepeatCall() {
        return this.isRepeat;
    }

    public String getOriginalHost() {
        return this.originalHost;
    }

    public void setTrustedPlugin(PLUGIN plugin) {
        this.trustedPlugin = plugin;
    }

    public PLUGIN getTrustedPlugin() {
        return this.trustedPlugin;
    }

    public void setBlockedPlugin(PLUGIN plugin) {
        this.blockedPlugin = plugin;
    }

    public PLUGIN getBlockedPlugin() {
        return this.blockedPlugin;
    }

    public static interface PluginFinder<PLUGIN> {
        public PLUGIN findPlugin(StackTraceElement var1);
    }

    private class BukkitPluginFinder
    implements PluginFinder<PLUGIN> {
        private BukkitPluginFinder() {
        }

        @Override
        public PLUGIN findPlugin(StackTraceElement element) {
            try {
                Class<?> clazz = Class.forName(element.getClassName());
                return JavaPlugin.getProvidingPlugin(clazz);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private class BungeePluginFinder
    implements PluginFinder<PLUGIN> {
        private final Class<?> pluginClassloaderClass;
        private final Field pluginField;

        private BungeePluginFinder() {
            try {
                this.pluginClassloaderClass = Class.forName("net.md_5.bungee.api.plugin.PluginClassloader");
                this.pluginField = this.pluginClassloaderClass.getDeclaredField("plugin");
                this.pluginField.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public PLUGIN findPlugin(StackTraceElement element) {
            Class<?> clazz;
            try {
                clazz = Class.forName(element.getClassName());
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
            ClassLoader cl = clazz.getClassLoader();
            if (cl == null || !cl.getClass().isAssignableFrom(this.pluginClassloaderClass)) {
                return null;
            }
            try {
                return this.pluginField.get(cl);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                System.err.println("Problem finding BungeeCoord plugin for network connection:");
                e.printStackTrace();
                return null;
            }
        }
    }

    private class DummyPluginFinder
    implements PluginFinder<PLUGIN> {
        private DummyPluginFinder() {
        }

        @Override
        public PLUGIN findPlugin(StackTraceElement element) {
            return null;
        }
    }
}

