/*
 * Decompiled with CFR 0.152.
 */
package com.nameme.bungee.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nameme.bungee.NameMe;
import com.nameme.shared.Callable;
import com.nameme.shared.URLUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class UUIDUtil {
    private NameMe plugin = (NameMe)ProxyServer.getInstance().getPluginManager().getPlugin("NameMe");
    private UUID uuid;
    private String username;
    private ArrayList<String> a = new ArrayList();
    private final String USER_TO_UUID = "https://api.mojang.com/users/profiles/minecraft/";
    private final String LOOKUP_URL = "https://api.mojang.com/user/profiles/%s/names";

    public UUIDUtil(String username) {
        this.setUsername(username);
    }

    public void nameToUUID(Callable<String> callable) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, () -> {
            String response = "-1";
            String url = "https://api.mojang.com/users/profiles/minecraft/" + this.getUsername().replace("'", "");
            try {
                String uuid;
                URL obj = new URL(url);
                if (obj == null) {
                    response = "Invalid Username";
                }
                HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
                con.connect();
                URLUtil urlutil = new URLUtil(con);
                JsonObject name = (JsonObject)new Gson().fromJson(urlutil.getResponse(), JsonObject.class);
                response = name == null ? "Invalid Username" : (name.toString().isEmpty() ? "Invalid Username" : (uuid = name.get("id").getAsString()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String finalResponse = response;
            ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, () -> callable.onSuccess(finalResponse));
        });
    }

    public void getNameHistory(String u, ProxiedPlayer p, Callable<ArrayList<String>> callable) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, () -> {
            String url = String.format("https://api.mojang.com/user/profiles/%s/names", u);
            try {
                URL obj = new URL(url);
                if (obj == null) {
                    p.sendMessage(new ComponentBuilder(ChatColor.DARK_RED + "ERROR: NULL").create());
                }
                HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
                con.setDoInput(true);
                con.setConnectTimeout(2000);
                con.setReadTimeout(2000);
                con.connect();
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String response = in.readLine();
                in.close();
                JsonArray nameHistory = (JsonArray)new Gson().fromJson(response, JsonArray.class);
                for (JsonElement element : nameHistory) {
                    JsonObject jsonObj = element.getAsJsonObject();
                    if (jsonObj.has("name") && !jsonObj.has("changedToAt")) {
                        this.a.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.config.getOriginalNameMessage().replaceFirst("(name)", jsonObj.get("name").getAsString())).replaceAll("[()]", ""));
                    }
                    if (!jsonObj.has("changedToAt") || !jsonObj.has("name")) continue;
                    Calendar time = Calendar.getInstance();
                    time.setTimeInMillis(jsonObj.get("changedToAt").getAsLong());
                    String date = this.plugin.config.getDateSystem() ? this.calculateEuropeanDate(time) : this.calculateAmericanDate(time);
                    this.a.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.config.getChangedNameMessage().replaceAll("(name)", jsonObj.get("name").getAsString()).replaceAll("(date)", date).replaceAll("[()]", "")));
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (SocketTimeoutException e) {
                this.a.add(ChatColor.RED + "Request timed out, please try again.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, () -> callable.onSuccess(this.a));
        });
    }

    public String calculateAmericanDate(Calendar time) {
        return time.get(2) + 1 + "/" + time.get(5) + "/" + time.get(1);
    }

    public String calculateEuropeanDate(Calendar time) {
        return time.get(5) + "/" + (time.get(2) + 1) + "/" + time.get(1);
    }

    public String getUUID() {
        return this.uuid.toString();
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

