/*
 * Decompiled with CFR 0.152.
 */
package com.nameme.bungee.command;

import com.nameme.bungee.NameMe;
import com.nameme.bungee.util.UUIDUtil;
import com.nameme.shared.Callable;
import com.nameme.shared.PlayerCache;
import java.util.ArrayList;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;

public class CommandNameMe
extends Command {
    private NameMe plugin = (NameMe)ProxyServer.getInstance().getPluginManager().getPlugin("NameMe");

    public CommandNameMe() {
        super("name");
    }

    public void execute(CommandSender sender, String[] args) {
        final ProxiedPlayer p = (ProxiedPlayer)sender;
        if (p.hasPermission("nameme.use")) {
            if (args.length == 1) {
                String localUUID;
                final String user = args[0];
                final UUIDUtil uu = new UUIDUtil(user);
                try {
                    localUUID = ProxyServer.getInstance().getPlayer(args[0]).getUniqueId().toString().replaceAll("-", "");
                }
                catch (Exception e) {
                    localUUID = "";
                }
                if (this.plugin.cc.isCacheEnabled() && PlayerCache.getInstance().getCacheList().containsKey(user)) {
                    for (String s : PlayerCache.getInstance().getCacheList().get(user)) {
                        p.sendMessage(new ComponentBuilder(s).create());
                    }
                    if (this.plugin.cc.isDebug()) {
                        p.sendMessage(new ComponentBuilder(ChatColor.RED + ChatColor.BOLD.toString() + "Debug: " + ChatColor.GREEN + "Using PlayerCache: " + ChatColor.RED + "true").create());
                    }
                }
                if (localUUID.equalsIgnoreCase("")) {
                    long startTime = 0L;
                    if (this.plugin.config.getDebug()) {
                        startTime = System.currentTimeMillis();
                    }
                    final long finalStartTime = startTime;
                    uu.nameToUUID(new Callable<String>(){

                        @Override
                        public void onSuccess(String done) {
                            if (done.equalsIgnoreCase("Invalid Username") || done.equalsIgnoreCase("-1")) {
                                p.sendMessage(new ComponentBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)((CommandNameMe)CommandNameMe.this).plugin.config.getInvalidUsernameMessage())).create());
                            } else {
                                uu.getNameHistory(done, p, new Callable<ArrayList<String>>(){

                                    @Override
                                    public void onSuccess(ArrayList<String> done) {
                                        for (String s : done) {
                                            p.sendMessage(new ComponentBuilder(s).create());
                                        }
                                        if (((CommandNameMe)CommandNameMe.this).plugin.config.getDebug()) {
                                            long timeElapsed = System.currentTimeMillis() - finalStartTime;
                                            p.sendMessage(new ComponentBuilder(ChatColor.RED + ChatColor.BOLD.toString() + "Debug: " + ChatColor.GREEN + "Took " + ChatColor.RED + timeElapsed + "ms" + ChatColor.GREEN + "!").create());
                                            p.sendMessage(new ComponentBuilder(ChatColor.RED + ChatColor.BOLD.toString() + "Debug: " + ChatColor.GREEN + "Using cache: " + ChatColor.RED + "false").create());
                                        }
                                        if (((CommandNameMe)CommandNameMe.this).plugin.cc.isCacheEnabled()) {
                                            PlayerCache.getInstance().addUser(user, done);
                                        }
                                    }

                                    @Override
                                    public void onFailure(Throwable cause) {
                                    }
                                });
                            }
                        }

                        @Override
                        public void onFailure(Throwable cause) {
                        }
                    });
                } else {
                    long startTime = 0L;
                    if (this.plugin.config.getDebug()) {
                        startTime = System.currentTimeMillis();
                    }
                    final long finalStartTime = startTime;
                    uu.getNameHistory(localUUID, p, new Callable<ArrayList<String>>(){

                        @Override
                        public void onSuccess(ArrayList<String> done) {
                            for (String s : done) {
                                p.sendMessage(new ComponentBuilder(s).create());
                            }
                            if (((CommandNameMe)CommandNameMe.this).plugin.config.getDebug()) {
                                long timeElapsed = System.currentTimeMillis() - finalStartTime;
                                p.sendMessage(new ComponentBuilder(ChatColor.RED + ChatColor.BOLD.toString() + "Debug: " + ChatColor.GREEN + "Took " + ChatColor.RED + timeElapsed + "ms" + ChatColor.GREEN + "!").create());
                                p.sendMessage(new ComponentBuilder(ChatColor.RED + ChatColor.BOLD.toString() + "Debug: " + ChatColor.GREEN + "Using cache: " + ChatColor.RED + "true").create());
                            }
                            if (((CommandNameMe)CommandNameMe.this).plugin.cc.isCacheEnabled()) {
                                PlayerCache.getInstance().addUser(user, done);
                            }
                        }

                        @Override
                        public void onFailure(Throwable cause) {
                        }
                    });
                }
            } else if (args.length == 0) {
                for (String s : this.plugin.config.getHelpMessage()) {
                    p.sendMessage(new ComponentBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)s)).create());
                }
            } else {
                p.sendMessage(new ComponentBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.config.getInvalidArgumentsMessage())).create());
            }
        } else {
            p.sendMessage(new ComponentBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.config.getPermissionDeniedMessage())).create());
        }
    }
}

