/*
 * Decompiled with CFR 0.152.
 */
package com.nameme.bungee;

import com.google.common.io.ByteStreams;
import com.nameme.bungee.command.CommandNameMe;
import com.nameme.bungee.util.NameMeConfig;
import com.nameme.shared.ConfigCache;
import com.nameme.shared.PlayerCache;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class NameMe
extends Plugin {
    public NameMeConfig config;
    public ConfigCache cc;

    public void onEnable() {
        this.createConfig();
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new CommandNameMe());
        this.config = new NameMeConfig(this.getConfig());
        this.cc = new ConfigCache(this.config);
    }

    public void onDisable() {
    }

    private void createConfig() {
        File configFile;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            try {
                configFile.createNewFile();
                try (InputStream is = this.getResourceAsStream("config.yml");
                     FileOutputStream os = new FileOutputStream(configFile);){
                    ByteStreams.copy((InputStream)is, (OutputStream)os);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create configuration file", e);
            }
        }
    }

    public Configuration getConfig() {
        try {
            return ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void startPlayerCacheService() {
        if (this.cc.isCacheEnabled()) {
            this.getProxy().getScheduler().schedule((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    PlayerCache.getInstance().getCacheList().clear();
                    if (NameMe.this.cc.isDebug()) {
                        NameMe.this.getProxy().getLogger().info(ChatColor.GREEN + "Clearing NameMe cache!");
                    }
                }
            }, 0L, (long)this.cc.getCacheRetention(), TimeUnit.MINUTES);
        }
    }
}

