/*
 * Decompiled with CFR 0.152.
 */
package com.nameme.bukkit.command;

import com.nameme.bukkit.NameMe;
import com.nameme.bukkit.util.UUIDUtil;
import com.nameme.shared.Callable;
import com.nameme.shared.PlayerCache;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandNameMe
implements CommandExecutor {
    private NameMe plugin = (NameMe)NameMe.getPlugin(NameMe.class);

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        final Player p = (Player)sender;
        if (p.hasPermission("nameme.use")) {
            if (args.length == 1) {
                String localUUID;
                final String user = args[0];
                final UUIDUtil uu = new UUIDUtil(user);
                try {
                    localUUID = Bukkit.getServer().getPlayer(args[0]).getUniqueId().toString().replaceAll("-", "");
                }
                catch (Exception e) {
                    localUUID = "";
                }
                if (this.plugin.cc.isCacheEnabled() && PlayerCache.getInstance().getCacheList().containsKey(user)) {
                    for (String s : PlayerCache.getInstance().getCacheList().get(user)) {
                        p.sendMessage(s);
                    }
                    if (this.plugin.cc.isDebug()) {
                        p.sendMessage(ChatColor.RED + ChatColor.BOLD.toString() + "Debug: " + ChatColor.GREEN + "Using PlayerCache: " + ChatColor.RED + "true");
                    }
                    return true;
                }
                if (localUUID.equalsIgnoreCase("")) {
                    long startTime = 0L;
                    if (this.plugin.cc.isDebug()) {
                        startTime = System.currentTimeMillis();
                    }
                    final long finalStartTime = startTime;
                    uu.nameToUUID(new Callable<String>(){

                        @Override
                        public void onSuccess(String done) {
                            if (done.equalsIgnoreCase("Invalid Username") || done.equalsIgnoreCase("-1")) {
                                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)((CommandNameMe)CommandNameMe.this).plugin.cc.getInvalidUsernameMessage()));
                            } else {
                                uu.getNameHistory(done, p, new Callable<ArrayList<String>>(){

                                    @Override
                                    public void onSuccess(ArrayList<String> done) {
                                        for (String s : done) {
                                            p.sendMessage(s);
                                        }
                                        if (((CommandNameMe)CommandNameMe.this).plugin.cc.isDebug()) {
                                            long timeElapsed = System.currentTimeMillis() - finalStartTime;
                                            p.sendMessage(ChatColor.RED + ChatColor.BOLD.toString() + "Debug: " + ChatColor.GREEN + "Took " + ChatColor.RED + timeElapsed + "ms" + ChatColor.GREEN + "!");
                                            p.sendMessage(ChatColor.RED + ChatColor.BOLD.toString() + "Debug: " + ChatColor.GREEN + "Using cache: " + ChatColor.RED + "false");
                                        }
                                        if (((CommandNameMe)CommandNameMe.this).plugin.cc.isCacheEnabled()) {
                                            PlayerCache.getInstance().addUser(user, done);
                                        }
                                    }

                                    @Override
                                    public void onFailure(Throwable cause) {
                                    }
                                });
                            }
                        }

                        @Override
                        public void onFailure(Throwable cause) {
                        }
                    });
                } else {
                    long startTime = 0L;
                    if (this.plugin.cc.isDebug()) {
                        startTime = System.currentTimeMillis();
                    }
                    final long finalStartTime = startTime;
                    uu.getNameHistory(localUUID, p, new Callable<ArrayList<String>>(){

                        @Override
                        public void onSuccess(ArrayList<String> done) {
                            for (String s : done) {
                                p.sendMessage(s);
                            }
                            if (((CommandNameMe)CommandNameMe.this).plugin.cc.isDebug()) {
                                long timeElapsed = System.currentTimeMillis() - finalStartTime;
                                p.sendMessage(ChatColor.RED + ChatColor.BOLD.toString() + "Debug: " + ChatColor.GREEN + "Took " + ChatColor.RED + timeElapsed + "ms" + ChatColor.GREEN + "!");
                                p.sendMessage(ChatColor.RED + ChatColor.BOLD.toString() + "Debug: " + ChatColor.GREEN + "Using cache: " + ChatColor.RED + "true");
                            }
                            if (((CommandNameMe)CommandNameMe.this).plugin.cc.isCacheEnabled()) {
                                PlayerCache.getInstance().addUser(user, done);
                            }
                        }

                        @Override
                        public void onFailure(Throwable cause) {
                        }
                    });
                }
            } else if (args.length == 0) {
                for (String s : this.plugin.cc.getHelpMessage()) {
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
                }
            } else {
                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.cc.getInvalidArgumentsMessage()));
            }
        } else {
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.cc.getPermissionDeniedMessage()));
        }
        return true;
    }
}

